/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlockEntity;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public class CBCCommonEvents {
    public static void register(IEventBus forgeEventBus) {
        forgeEventBus.addListener(CBCCommonEvents::onPlayerBreakBlock);
        forgeEventBus.addListener(CBCCommonEvents::onPlayerLogin);
        forgeEventBus.addListener(CBCCommonEvents::onPlayerLogout);
        forgeEventBus.addListener(CBCCommonEvents::onLoadWorld);
        forgeEventBus.addListener(CBCCommonEvents::onServerWorldTick);
        forgeEventBus.addListener(CBCCommonEvents::onDatapackSync);
        forgeEventBus.addListener(CBCCommonEvents::onAddReloadListeners);
    }

    public static void onServerWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (evt.side == LogicalSide.CLIENT) {
            return;
        }
        CreateBigCannons.BLOCK_DAMAGE.tick(evt.level);
    }

    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            BlockPos drillPos = CBCCommonEvents.destroyPoleContraption((Block)CBCBlocks.CANNON_DRILL_BIT.get(), (Block)CBCBlocks.CANNON_DRILL.get(), CannonDrillBlock.maxAllowedDrillLength(), event);
            if (drillPos != null) {
                level.m_7731_(drillPos, (BlockState)level.m_8055_(drillPos).m_61124_(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.RETRACTED), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CannonDrillBlockEntity) {
                    CannonDrillBlockEntity drill = (CannonDrillBlockEntity)blockEntity;
                    drill.onLengthBroken();
                }
                return;
            }
            BlockPos builderPos = CBCCommonEvents.destroyPoleContraption((Block)CBCBlocks.CANNON_BUILDER_HEAD.get(), (Block)CBCBlocks.CANNON_BUILDER.get(), CannonBuilderBlock.maxAllowedBuilderLength(), event);
            if (builderPos != null) {
                level.m_7731_(builderPos, (BlockState)level.m_8055_(builderPos).m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)CannonBuilderBlock.BuilderState.UNACTIVATED)), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CannonBuilderBlockEntity) {
                    CannonBuilderBlockEntity builder = (CannonBuilderBlockEntity)blockEntity;
                    builder.onLengthBroken();
                }
                return;
            }
        }
    }

    private static BlockPos destroyPoleContraption(Block head, Block base, int limit, BlockEvent.BreakEvent event) {
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction.Axis axis = ((Direction)event.getState().m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        Direction positive = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos headPos = null;
        BlockPos basePos = null;
        int[] nArray = new int[]{1, -1};
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int mod;
            int offs = mod = nArray[i];
            while (mod * offs < limit) {
                BlockPos pos1 = pos.m_5484_(positive, offs);
                BlockState state1 = level.m_8055_(pos1);
                if (!AllBlocks.PISTON_EXTENSION_POLE.has(state1) || axis != ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                    if (state1.m_60713_(head) && axis == ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                        headPos = pos1;
                    }
                    if (!state1.m_60713_(base) || axis != ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue block0;
                    basePos = pos1;
                    continue block0;
                }
                offs += mod;
            }
        }
        if (headPos == null || basePos == null) {
            return null;
        }
        Player player = event.getPlayer();
        BlockPos baseCopy = basePos.m_7949_();
        BlockPos.m_121990_(headPos, basePos).filter(p -> !p.equals((Object)pos) && !p.equals((Object)baseCopy)).forEach(p -> level.m_46961_(p, !player.m_7500_()));
        return baseCopy;
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        CreateBigCannons.BLOCK_DAMAGE.playerLogin(player);
    }

    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        CreateBigCannons.BLOCK_DAMAGE.playerLogout(player);
    }

    public static void onLoadWorld(LevelEvent.Load evt) {
        LevelAccessor level = evt.getLevel();
        CreateBigCannons.BLOCK_DAMAGE.levelLoaded(level);
        if (level.m_7654_() != null && level.m_7654_().m_129783_() == level) {
            BlockHardnessHandler.loadTags();
        }
    }

    public static void onDatapackSync(OnDatapackSyncEvent evt) {
        ServerPlayer player = evt.getPlayer();
        if (evt.getPlayer() == null) {
            BlockRecipesManager.syncToAll();
            BlockHardnessHandler.loadTags();
        } else {
            BlockRecipesManager.syncTo(player);
        }
    }

    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)BlockRecipeFinder.LISTENER);
        event.addListener((PreparableReloadListener)BlockRecipesManager.ReloadListener.INSTANCE);
        event.addListener((PreparableReloadListener)BlockHardnessHandler.ReloadListener.INSTANCE);
    }
}

