/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.CreateBigCannonsClient;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonMaterial;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.manualloading.RamRodItem;
import rbasamoyai.createbigcannons.manualloading.WormItem;

public class CBCTooltip {
    public static <T extends Block> void appendCannonBlockText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, T block) {
        boolean desc = Screen.m_96638_();
        String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
        if (holdDesc.length >= 2) {
            MutableComponent keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
            MutableComponent tabBuilder = Component.m_237113_((String)"");
            tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
            tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(desc ? ChatFormatting.WHITE : ChatFormatting.GRAY));
            tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)tabBuilder);
        }
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (desc) {
            BigCannonMaterial material = ((BigCannonBlock)block).getCannonMaterial();
            Minecraft mc = Minecraft.m_91087_();
            boolean hasGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
            String rootKey = "block.createbigcannons.cannon.tooltip";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)(rootKey + ".materialProperties"), (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".strength"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            int strength = material.maxSafeCharges();
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".strength.goggles"), (Object[])new Object[]{strength}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            } else {
                tooltip.add(CBCTooltip.getNoGogglesMeter(strength == 0 ? 0 : strength / 2 + 1, false, true));
            }
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".squibRatio"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".squibRatio.goggles"), (Object[])new Object[]{material.squibRatioNum(), material.squibRatioDem()}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            } else {
                double squibRatio = material.squibRatio();
                tooltip.add(CBCTooltip.getNoGogglesMeter(squibRatio < 1.0 ? 0 : Mth.m_14165_((double)(material.squibRatio() * 5.0 / 3.0)), false, true));
            }
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".weightImpact"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            float weightImpact = material.weight();
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".weightImpact.goggles"), (Object[])new Object[]{String.format("%.2f", Float.valueOf(weightImpact))}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            } else {
                tooltip.add(CBCTooltip.getNoGogglesMeter((double)weightImpact < 1.0 ? 0 : (int)(weightImpact * 0.5f), true, true));
            }
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".onFailure"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            String failKey = material.failureMode() == BigCannonMaterial.FailureMode.RUPTURE ? ".onFailure.rupture" : ".onFailure.fragment";
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + failKey), (Object[])new Object[0]), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
            if (ForgeRegistries.BLOCKS.tags().getTag(CBCTags.BlockCBC.WEAK_CANNON_END).contains(block) && (Integer)CBCConfigs.SERVER.cannons.weakBreechStrength.get() != -1) {
                int weakCharges = (Integer)CBCConfigs.SERVER.cannons.weakBreechStrength.get();
                tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".weakCannonEnd"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".weakCannonEnd.desc"), (Object[])new Object[]{weakCharges}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            }
        }
    }

    private static Component getNoGogglesMeter(int outOfFive, boolean invertColor, boolean canBeInvalid) {
        int value = invertColor ? 5 - outOfFive : outOfFive;
        ChatFormatting color = switch (value) {
            case 0, 1 -> ChatFormatting.RED;
            case 2, 3 -> ChatFormatting.GOLD;
            case 4, 5 -> ChatFormatting.YELLOW;
            default -> canBeInvalid ? ChatFormatting.DARK_GRAY : (value < 0 ? ChatFormatting.RED : ChatFormatting.YELLOW);
        };
        return Component.m_237113_((String)(" " + ItemDescription.makeProgressBar((int)5, (int)outOfFive))).m_130940_(color);
    }

    public static ItemDescription.Palette getPalette(Level level, ItemStack stack) {
        if (level == null) {
            return AllSections.UNASSIGNED.getTooltipPalette();
        }
        AllSections section = AllSections.of((ItemStack)stack);
        return section == null ? AllSections.UNASSIGNED.getTooltipPalette() : section.getTooltipPalette();
    }

    public static <T extends Block> void appendTextAutocannon(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, T block) {
        boolean desc = Screen.m_96638_();
        String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
        if (holdDesc.length >= 2) {
            MutableComponent keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
            MutableComponent tabBuilder = Component.m_237113_((String)"");
            tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
            tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(desc ? ChatFormatting.WHITE : ChatFormatting.GRAY));
            tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)tabBuilder);
        }
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (desc) {
            AutocannonMaterial material = ((AutocannonBlock)block).getAutocannonMaterial();
            Minecraft mc = Minecraft.m_91087_();
            boolean hasGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
            String rootKey = "block.createbigcannons.autocannon.tooltip";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)(rootKey + ".materialProperties"), (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            int maxLength = material.maxLength();
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".maxLength"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".maxLength.goggles"), (Object[])new Object[]{maxLength + 1}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            } else {
                tooltip.add(CBCTooltip.getNoGogglesMeter(maxLength == 0 ? 0 : (maxLength - 1) / 2 + 1, false, true));
            }
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".weightImpact"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            float weightImpact = material.weight();
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".weightImpact.goggles"), (Object[])new Object[]{String.format("%.2f", Float.valueOf(weightImpact))}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)2));
            } else {
                tooltip.add(CBCTooltip.getNoGogglesMeter((double)weightImpact < 1.0 ? 0 : Mth.m_14167_((float)weightImpact), true, true));
            }
        }
    }

    public static void appendMortarStoneText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (Screen.m_96638_()) {
            String key = stack.m_41778_() + ".tooltip.maximumCharges";
            tooltip.add((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.GRAY));
            String value = String.format("%.2f", CBCConfigs.SERVER.munitions.maxMortarStoneCharges.get());
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{value}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
        }
    }

    public static void appendRamRodText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (Screen.m_96638_()) {
            String keyBase = stack.m_41778_() + ".tooltip.";
            String key = keyBase + "pushStrength";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{RamRodItem.getPushStrength()}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
            String key1 = keyBase + "reach";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key1, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key1 + ".value"), (Object[])new Object[]{RamRodItem.getReach()}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
            String key2 = keyBase + "deployerCanUse";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key2, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key2 + (RamRodItem.deployersCanUse() ? ".yes" : ".no")), (Object[])new Object[0]), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
        }
    }

    public static void appendWormText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (Screen.m_96638_()) {
            String keyBase = stack.m_41778_() + ".tooltip.";
            String key = keyBase + "reach";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{WormItem.getReach()}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
            String key1 = keyBase + "deployerCanUse";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key1, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key1 + (WormItem.deployersCanUse() ? ".yes" : ".no")), (Object[])new Object[0]), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
        }
    }

    public static void appendImpactFuzeText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, float detChance) {
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (Screen.m_96638_()) {
            String key = stack.m_41778_() + ".tooltip.chance";
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{(int)(detChance * 100.0f)}), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
        }
    }

    public static void appendCannonCarriageText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, BlockItem block) {
        ItemDescription.Palette palette = CBCTooltip.getPalette(level, stack);
        if (Screen.m_96638_()) {
            String key = block.m_5524_() + ".tooltip";
            String fire = I18n.m_118938_((String)CreateBigCannonsClient.FIRE_CONTROLLED_CANNON.m_90863_().getString(), (Object[])new Object[0]);
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".keyPressed"), (Object[])new Object[]{fire}), (ChatFormatting)ChatFormatting.GRAY, (ChatFormatting)ChatFormatting.WHITE));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".fireCannon"), (Object[])new Object[0]), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
            String pitchMode = I18n.m_118938_((String)CreateBigCannonsClient.PITCH_MODE.m_90863_().getString(), (Object[])new Object[0]);
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".keyPressed"), (Object[])new Object[]{pitchMode}), (ChatFormatting)ChatFormatting.GRAY, (ChatFormatting)ChatFormatting.WHITE));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".pitchMode"), (Object[])new Object[0]), (ChatFormatting)palette.color, (ChatFormatting)palette.hColor, (int)1));
        }
    }
}

