/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.carriage;

import com.mojang.math.Vector4f;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.CBCEntityTypes;
import rbasamoyai.createbigcannons.CBCItems;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageBlock;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.network.CBCNetwork;
import rbasamoyai.createbigcannons.network.ServerboundCarriageWheelPacket;

public class CannonCarriageEntity
extends Entity
implements ControlPitchContraption {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_ID_RIDER = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_ID_WHEEL_LF = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ID_WHEEL_RF = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ID_WHEEL_LB = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ID_WHEEL_RB = SynchedEntityData.m_135353_(CannonCarriageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean inputForward;
    private boolean inputBackward;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputPitch;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    public Vector4f previousWheelState = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private PitchOrientedContraptionEntity cannonContraption;

    public CannonCarriageEntity(EntityType<? extends CannonCarriageEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public BlockState getControllerState() {
        return CBCBlocks.CANNON_CARRIAGE.getDefaultState();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_RIDER, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_WHEEL_LF, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_WHEEL_RF, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_WHEEL_LB, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_WHEEL_RB, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return true;
    }

    @Nullable
    public Entity m_6688_() {
        return this.canTurnCannon() ? (Entity)this.m_20197_().stream().filter(Player.class::isInstance).findFirst().orElse(null) : this.cannonContraption.m_6688_();
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.tickLerp();
        this.previousWheelState = this.getWheelState();
        if (this.m_6109_()) {
            this.moveCarriage();
            if (this.f_19853_.f_46443_) {
                this.controlCarriage();
                CBCNetwork.INSTANCE.sendToServer((Object)new ServerboundCarriageWheelPacket(this));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.f_19853_.f_46443_ && (entity = this.m_6688_()) instanceof Player) {
            Player player = (Player)entity;
            if (this.cannonContraption != null && this.cannonContraption.getContraption() instanceof MountedAutocannonContraption) {
                player.m_5661_((Component)Component.m_237110_((String)"block.createbigcannons.cannon_carriage.hotbar.fireRate", (Object[])new Object[]{this.getActualFireRate()}), true);
            }
        }
        this.applyRotation();
    }

    public void tryFiringShot() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (this.cannonContraption != null && (level = this.cannonContraption.getContraption()) instanceof AbstractMountedCannonContraption) {
                AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)level;
                Entity entity = this.m_6688_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (cannon instanceof MountedAutocannonContraption) {
                        MountedAutocannonContraption autocannon = (MountedAutocannonContraption)cannon;
                        autocannon.getItemOptional().ifPresent(h -> {
                            ItemStack stack = CannonCarriageEntity.getValidStack(player, arg_0 -> CBCItems.AUTOCANNON_CARTRIDGE.isIn(arg_0));
                            ItemStack result = h.insertItem(1, stack, false);
                            if (!player.m_7500_() && stack.m_41613_() != result.m_41613_()) {
                                stack.m_41764_(result.m_41613_());
                                if (stack.m_41619_()) {
                                    player.m_150109_().m_36057_(stack);
                                }
                            }
                        });
                    }
                }
                cannon.fireShot(slevel, this.cannonContraption);
            }
        }
    }

    public static ItemStack getValidStack(Player player, Predicate<ItemStack> pred) {
        ItemStack held = ProjectileWeaponItem.m_43010_((LivingEntity)player, pred);
        if (!held.m_41619_()) {
            return held;
        }
        Inventory playerInv = player.m_150109_();
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack stack = playerInv.m_8020_(i);
            if (!pred.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void moveCarriage() {
        double grav = this.m_20068_() ? 0.0 : (this.m_5842_() ? -7.0E-4 : -0.04);
        double friction = this.m_20069_() ? (double)0.9f : (double)0.05f;
        Vec3 oldVel = this.m_20184_();
        this.m_20334_(oldVel.f_82479_ * friction, oldVel.f_82480_ + grav, oldVel.f_82481_ * friction);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        double yawRad = Math.toRadians(this.m_146908_());
        double x = this.m_20185_() + Math.cos(yawRad) * 1.5;
        double z = this.m_20189_() + Math.sin(yawRad) * 1.5;
        return new Vec3(x, this.m_20186_() + 0.5, z);
    }

    private void controlCarriage() {
        if (!this.hasPlayerController() || !this.m_20096_()) {
            return;
        }
        float deltaYaw = 0.0f;
        Vector4f newState = this.getWheelState();
        float wMod = this.getWeightModifier();
        float turnRate = CBCConfigs.SERVER.cannons.carriageTurnRate.getF() * wMod;
        float speed = CBCConfigs.SERVER.cannons.carriageSpeed.getF() * wMod;
        boolean flag = this.canTurnCannon();
        if (flag) {
            if (this.inputLeft) {
                deltaYaw -= turnRate;
            }
            if (this.inputRight) {
                deltaYaw += turnRate;
            }
            this.m_146922_(this.m_146908_() + deltaYaw);
            float f = deltaYaw * 7.0f;
            newState.m_176875_(f, f, f, f);
        }
        float f1 = 0.0f;
        if (this.inputPitch && this.cannonContraption != null) {
            if (flag) {
                if (this.inputForward) {
                    f1 -= turnRate;
                }
                if (this.inputBackward) {
                    f1 += turnRate;
                }
                this.m_146926_(Mth.m_14036_((float)(this.m_146909_() - f1), (float)(-this.cannonContraption.maximumDepression()), (float)this.cannonContraption.maximumElevation()));
            }
        } else {
            if (this.inputForward) {
                f1 += speed;
            }
            if (this.inputBackward) {
                f1 -= speed * 0.5f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (double)f1, 0.0, (double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (double)f1));
            float f2 = f1 * 200.0f;
            newState.m_176875_(f2, f2, -f2, -f2);
        }
        this.setWheelState(newState);
    }

    protected float getWeightModifier() {
        Contraption contraption;
        if (!((Boolean)CBCConfigs.SERVER.cannons.cannonWeightAffectsCarriageSpeed.get()).booleanValue()) {
            return 1.0f;
        }
        if (this.cannonContraption == null || !((contraption = this.cannonContraption.getContraption()) instanceof AbstractMountedCannonContraption)) {
            return 1.0f;
        }
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        float weight = cannon.getWeightForStress();
        return weight <= 0.0f ? 1.0f : BigCannonMaterial.CAST_IRON.weight() * 5.0f / weight;
    }

    public void m_6453_(double lerpX, double lerpY, double lerpZ, float lerpYRot, float lerpXRot, int lerpSteps, boolean p_38305_) {
        this.lerpX = lerpX;
        this.lerpY = lerpY;
        this.lerpZ = lerpZ;
        this.lerpYRot = lerpYRot;
        this.lerpXRot = lerpXRot;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void setInput(boolean inputLeft, boolean inputRight, boolean inputForward, boolean inputBackward, boolean inputPitch) {
        this.inputLeft = inputLeft;
        this.inputRight = inputRight;
        this.inputForward = inputForward;
        this.inputBackward = inputBackward;
        this.inputPitch = inputPitch;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            if (stack.m_41619_() && this.isCannonRider()) {
                if (!this.f_19853_.f_46443_) {
                    this.setCannonRider(false);
                    player.m_36356_(Items.f_42450_.m_7968_());
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (stack.m_41619_()) {
            if (this.hasPlayerController() || this.m_5842_() || player.m_5842_()) {
                return InteractionResult.PASS;
            }
            if (this.f_19853_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!this.canTurnCannon()) {
                return player.m_20329_((Entity)this.cannonContraption) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (AllItems.WRENCH.isIn(stack)) {
            if (!this.f_19853_.f_46443_) {
                this.disassemble();
            }
            Direction dir = this.m_6350_();
            BlockPos placePos = this.m_20183_();
            if (this.f_19853_.m_8055_(placePos).m_60800_((BlockGetter)this.f_19853_, placePos) != -1.0f) {
                this.f_19853_.m_46961_(placePos, true);
                this.f_19853_.m_7731_(placePos, (BlockState)((BlockState)CBCBlocks.CANNON_CARRIAGE.getDefaultState().m_61124_((Property)CannonCarriageBlock.FACING, (Comparable)dir)).m_61124_((Property)CannonCarriageBlock.SADDLED, (Comparable)Boolean.valueOf(this.isCannonRider())), 11);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (stack.m_150930_(Items.f_42450_) && !this.isCannonRider()) {
            if (!this.f_19853_.f_46443_) {
                this.setCannonRider(true);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            this.f_19853_.m_6269_(player, (Entity)this, SoundEvents.f_12034_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    protected boolean canTurnCannon() {
        return this.cannonContraption == null || this.cannonContraption.canBeTurnedByController(this);
    }

    protected boolean m_7310_(Entity entity) {
        if (entity.m_6095_() == EntityType.f_20532_) {
            return !this.hasPlayerController();
        }
        return entity.m_6095_() == CBCEntityTypes.PITCH_ORIENTED_CONTRAPTION.get() && this.cannonContraption == null;
    }

    private boolean hasPlayerController() {
        return this.m_6688_() != null;
    }

    public void trySettingFireRateCarriage(int fireRateAdjustment) {
        Contraption contraption;
        if (!this.f_19853_.f_46443_ && this.cannonContraption != null && (contraption = this.cannonContraption.getContraption()) instanceof MountedAutocannonContraption) {
            MountedAutocannonContraption autocannon = (MountedAutocannonContraption)contraption;
            autocannon.trySettingFireRateCarriage(fireRateAdjustment);
        }
    }

    public int getActualFireRate() {
        int n;
        Contraption contraption;
        if (this.cannonContraption != null && (contraption = this.cannonContraption.getContraption()) instanceof MountedAutocannonContraption) {
            MountedAutocannonContraption autocannon = (MountedAutocannonContraption)contraption;
            n = autocannon.getReferencedFireRate();
        } else {
            n = 0;
        }
        return n;
    }

    public void m_7332_(Entity entity) {
        if (!(entity instanceof Player)) {
            super.m_7332_(entity);
            return;
        }
        if (!this.m_20363_(entity)) {
            return;
        }
        if (this.isCannonRider()) {
            entity.m_6034_(this.m_20185_(), this.m_20186_() + 1.375, this.m_20189_());
        } else {
            double yawRad = Math.toRadians(this.m_146908_());
            double x = this.m_20185_() + Math.cos(yawRad) * 1.5;
            double z = this.m_20189_() + Math.sin(yawRad) * 1.5;
            entity.m_6034_(x, this.m_20186_(), z);
        }
    }

    public double m_6048_() {
        return 0.84375;
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public void disassemble() {
        if (this.cannonContraption != null) {
            this.resetContraptionToOffset();
            this.cannonContraption.m_8127_();
        }
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_19853_, (Vec3i)this.m_20183_());
        this.m_146870_();
    }

    private void resetContraptionToOffset() {
        if (this.cannonContraption == null) {
            return;
        }
        this.m_146926_(0.0f);
        this.m_146922_(this.m_6350_().m_122435_());
        this.applyRotation();
        Vec3 vec = Vec3.m_82539_((Vec3i)this.m_20183_().m_7494_());
        this.cannonContraption.m_146884_(vec);
    }

    public void applyRotation() {
        if (this.cannonContraption == null) {
            return;
        }
        Direction dir = this.cannonContraption.getInitialOrientation();
        boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
        this.cannonContraption.prevPitch = flag ? this.f_19860_ : -this.f_19860_;
        this.cannonContraption.pitch = flag ? this.m_146909_() : -this.m_146909_();
        this.cannonContraption.prevYaw = this.f_19859_;
        this.cannonContraption.yaw = this.m_146908_();
    }

    public void m_7340_(Entity entity) {
        super.m_7340_(entity);
        if (this.cannonContraption == entity) {
            Direction dir = this.cannonContraption.getInitialOrientation();
            boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
            this.f_19860_ = flag ? this.cannonContraption.prevPitch : -this.cannonContraption.prevPitch;
            this.m_146926_(flag ? this.cannonContraption.pitch : -this.cannonContraption.pitch);
            this.f_19859_ = this.cannonContraption.prevYaw;
            this.m_146922_(this.cannonContraption.yaw);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.f_19853_.f_46443_ || this.m_213877_()) {
            return true;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + damage * 10.0f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, source.m_7639_());
        var5_3 = source.m_7639_();
        if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var5_3;
        if (player.m_150110_().f_35937_) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = flag = false;
        }
        if (flag || this.getDamage() > 40.0f) {
            if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19983_(CBCBlocks.CANNON_CARRIAGE.asStack());
                if (this.isCannonRider()) {
                    this.m_19998_((ItemLike)Items.f_42450_);
                }
            }
            this.disassemble();
        }
        return true;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int time) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)time);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int dir) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)dir);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setCannonRider(boolean cannonRider) {
        this.f_19804_.m_135381_(DATA_ID_RIDER, (Object)cannonRider);
    }

    public boolean isCannonRider() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_RIDER);
    }

    public void setWheelState(Vector4f vec) {
        this.f_19804_.m_135381_(DATA_ID_WHEEL_LF, (Object)Float.valueOf(vec.m_123601_()));
        this.f_19804_.m_135381_(DATA_ID_WHEEL_RF, (Object)Float.valueOf(vec.m_123615_()));
        this.f_19804_.m_135381_(DATA_ID_WHEEL_LB, (Object)Float.valueOf(vec.m_123616_()));
        this.f_19804_.m_135381_(DATA_ID_WHEEL_RB, (Object)Float.valueOf(vec.m_123617_()));
    }

    public Vector4f getWheelState() {
        return new Vector4f(((Float)this.f_19804_.m_135370_(DATA_ID_WHEEL_LF)).floatValue(), ((Float)this.f_19804_.m_135370_(DATA_ID_WHEEL_RF)).floatValue(), ((Float)this.f_19804_.m_135370_(DATA_ID_WHEEL_LB)).floatValue(), ((Float)this.f_19804_.m_135370_(DATA_ID_WHEEL_RB)).floatValue());
    }

    protected void m_7378_(CompoundTag tag) {
        this.setDamage(tag.m_128457_("Damage"));
        this.setHurtTime(tag.m_128451_("HurtTime"));
        this.setHurtDir(tag.m_128451_("HurtDir"));
        this.setCannonRider(tag.m_128471_("CannonRider"));
        ListTag wheelStateTag = tag.m_128437_("WheelState", 5);
        this.setWheelState(new Vector4f(wheelStateTag.m_128775_(0), wheelStateTag.m_128775_(1), wheelStateTag.m_128775_(2), wheelStateTag.m_128775_(3)));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("HurtTime", this.getHurtTime());
        tag.m_128405_("HurtDir", this.getHurtDir());
        tag.m_128379_("CannonRider", this.isCannonRider());
        ListTag wheelStateTag = new ListTag();
        Vector4f wheelState = this.getWheelState();
        wheelStateTag.add((Object)FloatTag.m_128566_((float)Mth.m_14177_((float)wheelState.m_123601_())));
        wheelStateTag.add((Object)FloatTag.m_128566_((float)Mth.m_14177_((float)wheelState.m_123615_())));
        wheelStateTag.add((Object)FloatTag.m_128566_((float)Mth.m_14177_((float)wheelState.m_123616_())));
        wheelStateTag.add((Object)FloatTag.m_128566_((float)Mth.m_14177_((float)wheelState.m_123617_())));
        tag.m_128365_("WheelState", (Tag)wheelStateTag);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static void build(EntityType.Builder<? extends CannonCarriageEntity> builder) {
        builder.setTrackingRange(8).m_20719_().setShouldReceiveVelocityUpdates(true).m_20699_(1.5f, 1.5f);
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity entity) {
        return this.cannonContraption == entity;
    }

    @Override
    public void attach(PitchOrientedContraptionEntity poce) {
        if (!(poce.getContraption() instanceof AbstractMountedCannonContraption)) {
            return;
        }
        poce.m_20329_(this);
        this.cannonContraption = poce;
        this.m_7332_((Entity)poce);
    }

    @Override
    public BlockPos getDismountPositionForContraption(PitchOrientedContraptionEntity poce) {
        return this.m_20183_().m_121945_(this.m_6350_().m_122424_()).m_7494_();
    }

    @Override
    public void onStall() {
    }
}

