/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.CBCContraptionTypes;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticleData;
import rbasamoyai.createbigcannons.cannons.ItemCannonBehavior;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBarrelBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonMaterial;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonRecoilSpringBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonRecoilSpringBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonCartridgeItem;
import rbasamoyai.createbigcannons.network.CBCNetwork;
import rbasamoyai.createbigcannons.network.ClientboundAnimateCannonContraptionPacket;

public class MountedAutocannonContraption
extends AbstractMountedCannonContraption {
    private AutocannonMaterial cannonMaterial;
    private BlockPos recoilSpringPos;
    private boolean isHandle = false;

    @Override
    public float maximumDepression(ControlPitchContraption controller) {
        BlockState state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 45.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return 15.0f;
        }
        return 0.0f;
    }

    @Override
    public float maximumElevation(ControlPitchContraption controller) {
        BlockState state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 90.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return this.isHandle ? 45.0f : 90.0f;
        }
        return 0.0f;
    }

    @Override
    public LazyOptional<IItemHandler> getItemOptional() {
        LazyOptional lazyOptional;
        Object v = this.presentTileEntities.get(this.startPos);
        if (v instanceof AutocannonBreechBlockEntity) {
            AutocannonBreechBlockEntity breech = (AutocannonBreechBlockEntity)v;
            lazyOptional = LazyOptional.of(breech::createItemHandler);
        } else {
            lazyOptional = LazyOptional.empty();
        }
        return lazyOptional;
    }

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.collectCannonBlocks(level, pos)) {
            return false;
        }
        this.bounds = new AABB(BlockPos.f_121853_);
        this.bounds = this.bounds.m_82400_(Math.ceil(Math.sqrt(MountedAutocannonContraption.getRadius(this.getBlocks().keySet(), (Direction.Axis)Direction.Axis.Y))));
        return !this.blocks.isEmpty();
    }

    private boolean collectCannonBlocks(Level level, BlockPos pos) throws AssemblyException {
        AutocannonRecoilSpringBlock springBlock;
        StructureTemplate.StructureBlockInfo possibleSpring;
        Object be;
        StructureTemplate.StructureBlockInfo localBlockInfo;
        BlockPos negativeEndPos;
        Block block;
        Block block2;
        BlockState startState = level.m_8055_(pos);
        Block block3 = startState.m_60734_();
        if (!(block3 instanceof AutocannonBlock)) {
            return false;
        }
        AutocannonBlock startCannon = (AutocannonBlock)block3;
        if (!startCannon.isComplete(startState)) {
            throw MountedAutocannonContraption.hasIncompleteCannonBlocks(pos);
        }
        AutocannonMaterial material = startCannon.getAutocannonMaterial();
        ArrayList<StructureTemplate.StructureBlockInfo> cannonBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        cannonBlocks.add(new StructureTemplate.StructureBlockInfo(pos, startState, this.getTileEntityNBT(level, pos)));
        int cannonLength = 1;
        Direction cannonFacing = startCannon.getFacing(startState);
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)cannonFacing.m_122434_());
        Direction negative = positive.m_122424_();
        BlockPos start = pos;
        BlockState nextState = level.m_8055_(pos.m_121945_(positive));
        boolean positiveBreech = false;
        while ((block2 = nextState.m_60734_()) instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block2;
            if (!this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(positive), positive, material)) break;
            start = start.m_121945_(positive);
            if (!cBlock.isComplete(nextState)) {
                throw MountedAutocannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getTileEntityNBT(level, start)));
            positiveBreech = cBlock.isBreechMechanism(nextState);
            nextState = level.m_8055_(start.m_121945_(positive));
            if (++cannonLength > MountedAutocannonContraption.getMaxCannonLength()) {
                throw MountedAutocannonContraption.cannonTooLarge();
            }
            if (!positiveBreech) continue;
        }
        BlockPos positiveEndPos = positiveBreech ? start : start.m_121945_(negative);
        start = pos;
        nextState = level.m_8055_(pos.m_121945_(negative));
        boolean negativeBreech = false;
        while ((block = nextState.m_60734_()) instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            if (!this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(negative), negative, material)) break;
            start = start.m_121945_(negative);
            if (!cBlock.isComplete(nextState)) {
                throw MountedAutocannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getTileEntityNBT(level, start)));
            negativeBreech = cBlock.isBreechMechanism(nextState);
            nextState = level.m_8055_(start.m_121945_(negative));
            if (++cannonLength > MountedAutocannonContraption.getMaxCannonLength()) {
                throw MountedAutocannonContraption.cannonTooLarge();
            }
            if (!negativeBreech) continue;
        }
        BlockPos blockPos = negativeEndPos = negativeBreech ? start : start.m_121945_(positive);
        if (positiveBreech && negativeBreech) {
            throw MountedAutocannonContraption.invalidCannon();
        }
        this.startPos = !positiveBreech && !negativeBreech ? pos : (negativeBreech ? negativeEndPos : positiveEndPos);
        BlockState breechState = level.m_8055_(this.startPos);
        if (!(breechState.m_60734_() instanceof AutocannonBreechBlock)) {
            throw MountedAutocannonContraption.invalidCannon();
        }
        this.initialOrientation = (Direction)breechState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.anchor = pos;
        this.startPos = this.startPos.m_121996_((Vec3i)pos);
        for (StructureTemplate.StructureBlockInfo blockInfo : cannonBlocks) {
            BlockPos localPos = blockInfo.f_74675_.m_121996_((Vec3i)pos);
            localBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, blockInfo.f_74676_, blockInfo.f_74677_);
            this.blocks.put(localPos, localBlockInfo);
            if (blockInfo.f_74677_ == null) continue;
            be = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)blockInfo.f_74676_, (CompoundTag)blockInfo.f_74677_);
            this.presentTileEntities.put(localPos, be);
        }
        StructureTemplate.StructureBlockInfo startInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos);
        if (startInfo == null || !(startInfo.f_74676_.m_60734_() instanceof AutocannonBreechBlock)) {
            throw MountedAutocannonContraption.noAutocannonBreech();
        }
        boolean bl = this.isHandle = startInfo.f_74676_.m_61138_((Property)AutocannonBreechBlock.HANDLE) && (Boolean)startInfo.f_74676_.m_61143_((Property)AutocannonBreechBlock.HANDLE) != false;
        if (this.isHandle) {
            this.getSeats().add(this.startPos.m_7949_());
        }
        if ((possibleSpring = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos.m_121945_(this.initialOrientation))) != null && (localBlockInfo = possibleSpring.f_74676_.m_60734_()) instanceof AutocannonRecoilSpringBlock && (springBlock = (AutocannonRecoilSpringBlock)localBlockInfo).getFacing(possibleSpring.f_74676_) == this.initialOrientation) {
            this.recoilSpringPos = this.startPos.m_121945_(this.initialOrientation).m_7949_();
            be = this.presentTileEntities.get(this.recoilSpringPos);
            if (be instanceof AutocannonRecoilSpringBlockEntity) {
                AutocannonRecoilSpringBlockEntity springBE = (AutocannonRecoilSpringBlockEntity)be;
                for (int i = 2; i < cannonLength; ++i) {
                    BlockPos pos1 = this.startPos.m_5484_(this.initialOrientation, i);
                    StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(pos1);
                    if (blockInfo == null) continue;
                    springBE.toAnimate.put(pos1.m_121996_((Vec3i)this.recoilSpringPos), blockInfo.f_74676_);
                    if (!blockInfo.f_74676_.m_61138_((Property)AutocannonBarrelBlock.ASSEMBLED)) continue;
                    this.blocks.put(pos1, new StructureTemplate.StructureBlockInfo(pos1, (BlockState)blockInfo.f_74676_.m_61124_((Property)AutocannonBarrelBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true)), blockInfo.f_74677_));
                }
                CompoundTag newTag = springBE.m_187480_();
                newTag.m_128473_("x");
                newTag.m_128473_("y");
                newTag.m_128473_("z");
                this.blocks.put(this.recoilSpringPos, new StructureTemplate.StructureBlockInfo(this.recoilSpringPos, possibleSpring.f_74676_, newTag));
            }
        }
        this.cannonMaterial = material;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToCannon(LevelAccessor level, BlockState state, BlockPos pos, Direction connection, AutocannonMaterial material) {
        AutocannonBlock cBlock = (AutocannonBlock)state.m_60734_();
        if (cBlock.getAutocannonMaterialInLevel(level, state, pos) != material) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IAutocannonBlockEntity)) return false;
        IAutocannonBlockEntity cbe = (IAutocannonBlockEntity)blockEntity;
        blockEntity = level.m_7702_(pos.m_121945_(connection.m_122424_()));
        if (!(blockEntity instanceof IAutocannonBlockEntity)) return false;
        IAutocannonBlockEntity cbe1 = (IAutocannonBlockEntity)blockEntity;
        if (!((ItemCannonBehavior)((Object)cbe.cannonBehavior())).isConnectedTo(connection.m_122424_())) return false;
        if (!((ItemCannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(connection)) return false;
        return true;
    }

    public static AssemblyException noAutocannonBreech() {
        return new AssemblyException((Component)Component.m_237115_((String)"exception.createbigcannons.cannon_mount.noAutocannonBreech"));
    }

    public void addBlocksToWorld(Level world, StructureTransform transform) {
        HashMap<BlockPos, StructureTemplate.StructureBlockInfo> modifiedBlocks = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        for (Map.Entry entry : this.blocks.entrySet()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)entry.getValue();
            BlockState newState = info.f_74676_;
            boolean modified = true;
            if (newState.m_61138_((Property)AutocannonBarrelBlock.ASSEMBLED) && ((Boolean)newState.m_61143_((Property)AutocannonBarrelBlock.ASSEMBLED)).booleanValue()) {
                newState = (BlockState)newState.m_61124_((Property)AutocannonBarrelBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false));
                modified = true;
            }
            if (info.f_74677_ != null) {
                if (info.f_74677_.m_128441_("AnimateTicks")) {
                    info.f_74677_.m_128473_("AnimateTicks");
                    modified = true;
                }
                if (info.f_74677_.m_128441_("RenderedBlocks")) {
                    info.f_74677_.m_128473_("RenderedBlocks");
                    modified = true;
                }
            }
            if (!modified) continue;
            modifiedBlocks.put(info.f_74675_, new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_));
        }
        this.blocks.putAll(modifiedBlocks);
        super.addBlocksToWorld(world, transform);
    }

    @Override
    public void fireShot(ServerLevel level, PitchOrientedContraptionEntity entity) {
        Object v;
        ItemStack output;
        AutocannonBreechBlockEntity breech;
        Object v2;
        if (this.startPos == null || this.cannonMaterial == null || !((v2 = this.presentTileEntities.get(this.startPos)) instanceof AutocannonBreechBlockEntity) || !(breech = (AutocannonBreechBlockEntity)v2).canFire()) {
            return;
        }
        ItemStack foundProjectile = breech.extractNextInput();
        Item item = foundProjectile.m_41720_();
        if (!(item instanceof AutocannonCartridgeItem)) {
            return;
        }
        AutocannonCartridgeItem round = (AutocannonCartridgeItem)item;
        Vec3 ejectPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos.m_121945_(this.isHandle ? Direction.DOWN : this.initialOrientation.m_122424_())), 1.0f);
        Vec3 centerPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), 1.0f);
        ItemStack ejectStack = round.getEmptyCartridge(foundProjectile);
        if (!ejectStack.m_41619_() && !(output = breech.insertOutput(ejectStack)).m_41619_()) {
            ItemEntity ejectEntity = new ItemEntity((Level)level, ejectPos.f_82479_, ejectPos.f_82480_, ejectPos.f_82481_, ejectStack);
            Vec3 eject = ejectPos.m_82546_(centerPos).m_82541_();
            ejectEntity.m_20256_(eject.m_82490_(this.isHandle ? 0.1 : 0.5));
            level.m_7967_((Entity)ejectEntity);
        }
        boolean canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        BlockPos currentPos = this.startPos.m_121945_(this.initialOrientation);
        int barrelTravelled = 0;
        while ((v = this.presentTileEntities.get(currentPos)) instanceof IAutocannonBlockEntity) {
            IAutocannonBlockEntity autocannon = (IAutocannonBlockEntity)v;
            ItemCannonBehavior behavior = (ItemCannonBehavior)((Object)autocannon.cannonBehavior());
            if (behavior.canLoadItem(foundProjectile)) {
                if (++barrelTravelled > this.cannonMaterial.maxLength()) {
                    StructureTemplate.StructureBlockInfo oldInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(currentPos);
                    behavior.tryLoadingItem(foundProjectile);
                    CompoundTag tag = ((BlockEntity)this.presentTileEntities.get(currentPos)).m_187480_();
                    tag.m_128473_("x");
                    tag.m_128473_("y");
                    tag.m_128473_("z");
                    StructureTemplate.StructureBlockInfo squibInfo = new StructureTemplate.StructureBlockInfo(currentPos, oldInfo.f_74676_, tag);
                    this.blocks.put(currentPos, squibInfo);
                    Vec3 squibPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos), 1.0f);
                    level.m_6263_(null, squibPos.f_82479_, squibPos.f_82480_, squibPos.f_82481_, oldInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 10.0f, 0.0f);
                    return;
                }
                currentPos = currentPos.m_121945_(this.initialOrientation);
                continue;
            }
            behavior.removeItem();
            if (canFail) {
                Vec3 failurePoint = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos), 1.0f);
                level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, 2.0f, Explosion.BlockInteraction.NONE);
                for (int i = 0; i < 10; ++i) {
                    BlockPos pos = currentPos.m_5484_(this.initialOrientation, i);
                    this.blocks.remove(pos);
                }
                ControlPitchContraption controller = entity.getController();
                if (controller != null) {
                    controller.disassemble();
                }
            }
            return;
        }
        Vec3 spawnPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
        Vec3 vec1 = spawnPos.m_82546_(centerPos).m_82541_();
        Vec3 particlePos = spawnPos.m_82546_(vec1.m_82490_(1.5));
        AbstractAutocannonProjectile projectile = AutocannonCartridgeItem.getAutocannonProjectile(foundProjectile, (Level)level);
        if (projectile != null) {
            projectile.m_146884_(spawnPos);
            projectile.setChargePower(barrelTravelled);
            projectile.setTracer(true);
            projectile.m_6686_(vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, barrelTravelled, 0.05f);
            projectile.f_19860_ = projectile.m_146909_();
            projectile.f_19859_ = projectile.m_146908_();
            level.m_7967_((Entity)projectile);
        }
        breech.handleFiring();
        Object squibPos = this.presentTileEntities.get(this.recoilSpringPos);
        if (squibPos instanceof AutocannonRecoilSpringBlockEntity) {
            AutocannonRecoilSpringBlockEntity spring = (AutocannonRecoilSpringBlockEntity)squibPos;
            spring.handleFiring();
        }
        CBCNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ClientboundAnimateCannonContraptionPacket((AbstractContraptionEntity)entity));
        for (ServerPlayer player : level.m_6907_()) {
            if (entity.m_6688_() == player) continue;
            level.m_8624_(player, (ParticleOptions)new CannonPlumeParticleData(0.1f), true, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, 1.0);
        }
        level.m_6263_(null, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, 2.0f);
    }

    @Override
    public void animate() {
        super.animate();
        Object v = this.presentTileEntities.get(this.startPos);
        if (v instanceof AutocannonBreechBlockEntity) {
            AutocannonBreechBlockEntity breech = (AutocannonBreechBlockEntity)v;
            breech.handleFiring();
        }
        if ((v = this.presentTileEntities.get(this.recoilSpringPos)) instanceof AutocannonRecoilSpringBlockEntity) {
            AutocannonRecoilSpringBlockEntity spring = (AutocannonRecoilSpringBlockEntity)v;
            spring.handleFiring();
        }
    }

    @Override
    public void tick(Level level, PitchOrientedContraptionEntity entity) {
        super.tick(level, entity);
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (this.canBeFiredOnController(entity.getController())) {
                this.fireShot(slevel, entity);
            }
        }
        for (Map.Entry entry : this.presentTileEntities.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof IAutocannonBlockEntity)) continue;
            IAutocannonBlockEntity autocannon = (IAutocannonBlockEntity)v;
            autocannon.tickFromContraption(level, entity, (BlockPos)entry.getKey());
        }
    }

    @Override
    public BlockPos getSeatPos(Entity entity) {
        return entity == this.entity.m_6688_() ? this.startPos.m_121945_(this.initialOrientation.m_122424_()) : super.getSeatPos(entity);
    }

    @Override
    public boolean canBeTurnedByController(ControlPitchContraption control) {
        return !this.isHandle;
    }

    @Override
    public boolean canBeTurnedByPassenger(Entity entity) {
        return this.isHandle && entity instanceof Player;
    }

    @Override
    public boolean canBeFiredOnController(ControlPitchContraption control) {
        return !this.isHandle && this.entity.m_20202_() != control;
    }

    @Override
    public void onRedstoneUpdate(ServerLevel level, PitchOrientedContraptionEntity entity, boolean togglePower, int firePower) {
        Object v = this.presentTileEntities.get(this.startPos);
        if (v instanceof AutocannonBreechBlockEntity) {
            AutocannonBreechBlockEntity breech = (AutocannonBreechBlockEntity)v;
            breech.setFireRate(firePower);
        }
    }

    public void trySettingFireRateCarriage(int fireRateAdjustment) {
        Object v = this.presentTileEntities.get(this.startPos);
        if (v instanceof AutocannonBreechBlockEntity) {
            AutocannonBreechBlockEntity breech = (AutocannonBreechBlockEntity)v;
            if (fireRateAdjustment > 0 || breech.getFireRate() > 1) {
                breech.setFireRate(breech.getFireRate() + fireRateAdjustment);
            }
        }
    }

    public int getReferencedFireRate() {
        int n;
        Object v = this.presentTileEntities.get(this.startPos);
        if (v instanceof AutocannonBreechBlockEntity) {
            AutocannonBreechBlockEntity breech = (AutocannonBreechBlockEntity)v;
            n = breech.getActualFireRate();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public float getWeightForStress() {
        return this.cannonMaterial == null ? (float)this.blocks.size() : (float)this.blocks.size() * this.cannonMaterial.weight();
    }

    @Override
    public CompoundTag writeNBT(boolean clientData) {
        CompoundTag tag = super.writeNBT(clientData);
        tag.m_128359_("AutocannonMaterial", this.cannonMaterial == null ? AutocannonMaterial.CAST_IRON.name().toString() : this.cannonMaterial.name().toString());
        if (this.startPos != null) {
            tag.m_128365_("StartPos", (Tag)NbtUtils.m_129224_((BlockPos)this.startPos));
        }
        if (this.recoilSpringPos != null) {
            tag.m_128365_("RecoilSpringPos", (Tag)NbtUtils.m_129224_((BlockPos)this.recoilSpringPos));
        }
        tag.m_128379_("IsHandle", this.isHandle);
        return tag;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean clientData) {
        super.readNBT(level, tag, clientData);
        this.cannonMaterial = AutocannonMaterial.fromName(new ResourceLocation(tag.m_128461_("AutocannonMaterial")));
        this.startPos = tag.m_128441_("StartPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("StartPos")) : null;
        this.recoilSpringPos = tag.m_128441_("RecoilSpringPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("RecoilSpringPos")) : null;
        this.isHandle = tag.m_128471_("IsHandle");
    }

    protected ContraptionType getType() {
        return CBCContraptionTypes.MOUNTED_AUTOCANNON;
    }
}

