/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.createbigcannons.CBCEntityTypes;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.CBCContraptionRotationState;

public class PitchOrientedContraptionEntity
extends OrientedContraptionEntity {
    private BlockPos controllerPos;
    private boolean updatesOwnRotation;
    private LazyOptional<IItemHandler> itemOptional;

    public PitchOrientedContraptionEntity(EntityType<? extends PitchOrientedContraptionEntity> type, Level level) {
        super(type, level);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.itemOptional == null) {
                LazyOptional<IItemHandler> lazyOptional;
                Contraption contraption = this.contraption;
                if (contraption instanceof AbstractMountedCannonContraption) {
                    AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
                    lazyOptional = cannon.getItemOptional();
                } else {
                    lazyOptional = LazyOptional.empty();
                }
                this.itemOptional = lazyOptional;
            }
            return this.itemOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemOptional != null) {
            this.itemOptional.invalidate();
        }
    }

    public static PitchOrientedContraptionEntity create(Level level, Contraption contraption, Direction initialOrientation, boolean updatesOwnRotation) {
        PitchOrientedContraptionEntity entity = new PitchOrientedContraptionEntity((EntityType<? extends PitchOrientedContraptionEntity>)((EntityType)CBCEntityTypes.PITCH_ORIENTED_CONTRAPTION.get()), level);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        entity.updatesOwnRotation = updatesOwnRotation;
        return entity;
    }

    public static PitchOrientedContraptionEntity create(Level level, Contraption contraption, Direction initialOrientation, ControlPitchContraption.Block block) {
        PitchOrientedContraptionEntity poce = PitchOrientedContraptionEntity.create(level, contraption, initialOrientation, true);
        poce.controllerPos = block.getControllerBlockPos();
        return poce;
    }

    protected void readAdditional(CompoundTag compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        if (compound.m_128441_("ControllerRelative")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("ControllerRelative")).m_121955_((Vec3i)this.m_20183_());
        } else {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.m_20183_().m_6625_(2));
            if (blockEntity instanceof ControlPitchContraption.Block) {
                ControlPitchContraption.Block controller = (ControlPitchContraption.Block)blockEntity;
                if (!this.m_20159_()) {
                    this.controllerPos = controller.getControllerBlockPos();
                }
            }
        }
        this.updatesOwnRotation = compound.m_128471_("UpdatesOwnRotation");
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        if (this.controllerPos != null) {
            compound.m_128365_("ControllerRelative", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos.m_121996_((Vec3i)this.m_20183_())));
        }
        compound.m_128379_("UpdatesOwnRotation", this.updatesOwnRotation);
    }

    protected ControlPitchContraption getController() {
        ControlPitchContraption controller;
        if (this.controllerPos != null) {
            ControlPitchContraption controller2;
            if (!this.f_19853_.m_46749_(this.controllerPos)) {
                return null;
            }
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.controllerPos);
            return blockEntity instanceof ControlPitchContraption ? (controller2 = (ControlPitchContraption)blockEntity) : null;
        }
        Entity entity = this.m_20202_();
        return entity instanceof ControlPitchContraption ? (controller = (ControlPitchContraption)entity) : null;
    }

    protected void tickContraption() {
        ControlPitchContraption controller;
        super.tickContraption();
        if (this.updatesOwnRotation) {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
        }
        this.contraption.anchor = this.m_20183_();
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.tick(this.f_19853_, this);
        }
        if ((controller = this.getController()) == null) {
            if (!this.f_19853_.f_46443_) {
                this.disassemble();
            }
            return;
        }
        if (!controller.isAttachedTo((AbstractContraptionEntity)this)) {
            controller.attach(this);
            if (this.f_19853_.f_46443_) {
                this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    public void handleAnimation() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.animate();
        }
    }

    public float maximumDepression() {
        float f;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            f = cannon.maximumDepression(this.getController());
        } else {
            f = 90.0f;
        }
        return f;
    }

    public float maximumElevation() {
        float f;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            f = cannon.maximumElevation(this.getController());
        } else {
            f = 90.0f;
        }
        return f;
    }

    protected void onContraptionStalled() {
        ControlPitchContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return new CBCContraptionRotationState(this);
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, Entity riding, boolean isOnCoupling) {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        float prevYaw = this.yaw;
        super.m_7350_(key);
        this.yaw = prevYaw;
    }

    public void applyLocalTransforms(PoseStack stack, float partialTicks) {
        float initialYaw = this.getInitialYaw();
        float pitch = this.m_5686_(partialTicks);
        float yaw = this.m_5675_(partialTicks) + initialYaw;
        stack.m_85837_(-0.5, 0.0, -0.5);
        TransformStack tstack = (TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)stack).nudge(this.m_19879_())).centre()).rotateY((double)yaw);
        if (this.getInitialOrientation().m_122434_() == Direction.Axis.X) {
            tstack.rotateZ((double)pitch);
        } else {
            tstack.rotateX((double)pitch);
        }
        tstack.unCentre();
    }

    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.m_5686_(partialTicks), (Direction.Axis)(this.getInitialOrientation().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.m_5675_(partialTicks), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)this.getInitialYaw(), (Direction.Axis)Direction.Axis.Y);
        return localPos;
    }

    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.getInitialYaw()), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.m_5675_(partialTicks)), (Direction.Axis)Direction.Axis.Y);
        localPos = VecHelper.rotate((Vec3)localPos, (double)(-this.m_5686_(partialTicks)), (Direction.Axis)(this.getInitialOrientation().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        return localPos;
    }

    public float getRotationCoefficient() {
        float f;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            f = Math.max(1.0f / cannon.getWeightForStress(), 0.1f);
        } else {
            f = 0.1f;
        }
        return f;
    }

    public void m_7340_(Entity entity) {
        AbstractMountedCannonContraption cannon;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption && (cannon = (AbstractMountedCannonContraption)contraption).canBeTurnedByPassenger(entity)) {
            Direction dir = this.getInitialOrientation();
            boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
            this.prevPitch = flag ? -entity.f_19860_ : entity.f_19860_;
            this.pitch = flag ? -entity.m_146909_() : entity.m_146909_();
            this.prevYaw = entity.f_19859_;
            this.yaw = entity.m_146908_();
            entity.m_5618_(entity.m_146908_());
            if (CBCEntityTypes.CANNON_CARRIAGE.is(this.m_20202_())) {
                this.m_20202_().m_7340_((Entity)this);
            } else {
                ControlPitchContraption controlPitchContraption = this.getController();
                if (controlPitchContraption instanceof CannonMountBlockEntity) {
                    CannonMountBlockEntity mount = (CannonMountBlockEntity)controlPitchContraption;
                    mount.applyHandRotation();
                    this.f_19860_ = this.prevPitch;
                    this.m_146926_(this.pitch);
                    this.f_19859_ = this.prevYaw;
                    this.m_146922_(this.yaw);
                }
            }
        }
    }

    public void addSittingPassenger(Entity passenger, int seatIndex) {
        Mob mob;
        Entity entity;
        if (passenger instanceof Mob && (entity = (mob = (Mob)passenger).m_21524_()) instanceof Player) {
            Player player = (Player)entity;
            this.addSittingPassenger((Entity)player, seatIndex);
        }
        super.addSittingPassenger(passenger, seatIndex);
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        Direction dir = this.getInitialOrientation();
        boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
        entity.m_146926_(flag ? -this.pitch : this.prevPitch);
        entity.m_146922_(this.yaw);
        entity.f_19860_ = flag ? -this.prevPitch : this.prevPitch;
        entity.f_19859_ = this.prevYaw;
    }

    public Vec3 getPassengerPosition(Entity passenger, float partialTicks) {
        Contraption contraption;
        if (passenger != this.m_6688_() || !((contraption = this.contraption) instanceof AbstractMountedCannonContraption)) {
            return super.getPassengerPosition(passenger, partialTicks);
        }
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        BlockPos seat = cannon.getSeatPos(passenger);
        if (seat == null) {
            return null;
        }
        return this.toGlobalVector(Vec3.m_82528_((Vec3i)seat).m_82520_(0.5, 1.0, 0.5), partialTicks).m_82492_(0.0, (double)passenger.m_20192_(), 0.0);
    }

    public Vec3 m_7688_(LivingEntity entityLiving) {
        ControlPitchContraption controller = this.getController();
        Vec3 superResult = super.m_7688_(entityLiving);
        return controller != null ? Vec3.m_82512_((Vec3i)controller.getDismountPositionForContraption(this)) : superResult;
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
    }

    public BlockPos getSeatPos(Entity passenger) {
        return ((AbstractMountedCannonContraption)this.contraption).getSeatPos(passenger);
    }

    @Nullable
    public Entity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public boolean canBeTurnedByController(ControlPitchContraption control) {
        AbstractMountedCannonContraption cannon;
        Contraption contraption = this.contraption;
        return contraption instanceof AbstractMountedCannonContraption && (cannon = (AbstractMountedCannonContraption)contraption).canBeTurnedByController(control);
    }

    public void tryFiringShot() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            contraption = this.f_19853_;
            if (contraption instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)contraption;
                cannon.fireShot(slevel, this);
            }
        }
    }

    public static float getRotationCap() {
        return 0.1f;
    }
}

