/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.base.PoleMoverBlockEntity;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderCollider;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderHeadBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuildingContraption;

public class CannonBuilderBlockEntity
extends PoleMoverBlockEntity {
    public CannonBuilderBlockEntity(BlockEntityType<? extends CannonBuilderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected PoleContraption innerAssemble() throws AssemblyException {
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof CannonBuilderBlock)) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CannonBuilderBlock.FACING);
        CannonBuildingContraption contraption = new CannonBuildingContraption(facing, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
            return null;
        }
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)facing.m_122434_());
        Direction movementDirection = this.getSpeed() > 0.0f ^ facing.m_122434_() != Direction.Axis.Z ? positive : positive.m_122424_();
        BlockPos anchor = contraption.anchor.m_5484_(facing, contraption.initialExtensionProgress());
        return CannonBuilderCollider.isCollidingWithWorld(this.f_58857_, contraption, anchor.m_121945_(movementDirection), movementDirection) ? null : contraption;
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.f_58859_) {
            this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)CannonBuilderBlock.BuilderState.EXTENDED)), 19);
        }
        super.disassemble();
    }

    protected boolean moveAndCollideContraption() {
        if (this.movedContraption == null) {
            return false;
        }
        if (this.movedContraption.isStalled()) {
            this.movedContraption.m_20256_(Vec3.f_82478_);
            return false;
        }
        Vec3 motion = this.getMotionVector();
        this.movedContraption.setContraptionMotion(motion);
        this.movedContraption.move(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        return CannonBuilderCollider.collideBlocks(this.movedContraption);
    }

    public BlockState updateBlockstatesOnPowered(BlockState state) {
        if (!state.m_61138_(CannonBuilderBlock.STATE)) {
            return state;
        }
        CannonBuilderBlock.BuilderState bState = (CannonBuilderBlock.BuilderState)((Object)state.m_61143_(CannonBuilderBlock.STATE));
        if (bState == CannonBuilderBlock.BuilderState.ACTIVATED || bState == CannonBuilderBlock.BuilderState.UNACTIVATED) {
            return (BlockState)state.m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)(bState == CannonBuilderBlock.BuilderState.ACTIVATED ? CannonBuilderBlock.BuilderState.UNACTIVATED : CannonBuilderBlock.BuilderState.ACTIVATED)));
        }
        if (this.running || this.movedContraption != null) {
            return state;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        for (int offs = 1; offs < CannonBuilderBlock.maxAllowedBuilderLength(); ++offs) {
            BlockPos currentPos = this.f_58858_.m_5484_(facing, offs);
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            if (AllBlocks.PISTON_EXTENSION_POLE.has(currentState)) {
                if (((Direction)currentState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == facing.m_122434_()) continue;
                break;
            }
            if (!CBCBlocks.CANNON_BUILDER_HEAD.has(currentState)) break;
            this.f_58857_.m_7731_(currentPos, (BlockState)currentState.m_61122_((Property)CannonBuilderHeadBlock.ATTACHED), 2);
            break;
        }
        return state;
    }
}

