/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.WandActionable;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe;
import rbasamoyai.createbigcannons.crafting.casting.FinishedCannonCastBlockEntity;

public class CannonCastBlockEntity
extends SmartTileEntity
implements WandActionable,
IMultiTileContainer {
    private static final Object CASTING_RECIPES_KEY = new Object();
    protected FluidTank fluid;
    protected LazyOptional<IFluidHandler> fluidOptional = null;
    protected List<CannonCastShape> structure = new ArrayList<CannonCastShape>();
    protected CannonCastShape castShape = null;
    protected BlockPos controllerPos;
    protected BlockPos lastKnownPos;
    protected int height = 1;
    protected FluidStack leakage = FluidStack.EMPTY;
    protected boolean forceFluidLevelUpdate = true;
    protected boolean forceCastLevelUpdate = true;
    protected int castingTime;
    protected int startCastingTime = 1;
    protected Map<CannonCastShape, CannonCastingRecipe> recipes = new HashMap<CannonCastShape, CannonCastingRecipe>();
    protected List<BlockState> resultPreview = new ArrayList<BlockState>();
    protected boolean updateRecipes = true;
    private static final int SYNC_RATE = 8;
    protected boolean queuedSync;
    protected int syncCooldown;
    private LerpedFloat fluidLevel;
    private LerpedFloat castLevel;

    public CannonCastBlockEntity(BlockEntityType<? extends CannonCastBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluid = new SmartFluidTank(1, this::onFluidStackChanged);
        this.fluidOptional = LazyOptional.of(() -> this.fluid);
        this.refreshCap();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.UP) {
            if (this.fluidOptional == null) {
                this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
            }
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
        }
    }

    public void refreshCap() {
        if (this.fluidOptional == null) {
            this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
        } else {
            LazyOptional<IFluidHandler> oldOp = this.fluidOptional;
            this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
            oldOp.invalidate();
        }
    }

    private IFluidHandler createHandlerForCap() {
        return this.isController() ? this.fluid : (this.getControllerTE() == null ? this.fluid : this.getControllerTE().createHandlerForCap());
    }

    public FluidTank getTank() {
        return this.fluid;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        Registry<CannonCastShape> castReg = CBCRegistries.getRegistry(CBCRegistries.CANNON_CAST_SHAPES_KEY);
        if (this.canRenderCastModel() && this.castShape != null) {
            tag.m_128359_("Size", castReg.m_7981_((Object)this.castShape).toString());
        }
        if (this.lastKnownPos != null) {
            tag.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (this.isController()) {
            if (!this.structure.isEmpty()) {
                ListTag structureTag = new ListTag();
                for (CannonCastShape sz : this.structure) {
                    structureTag.add((Object)StringTag.m_129297_((String)castReg.m_7981_((Object)sz).toString()));
                }
                tag.m_128365_("Structure", (Tag)structureTag);
            }
            tag.m_128405_("Height", this.height);
            tag.m_128365_("FluidContent", (Tag)this.fluid.writeToNBT(new CompoundTag()));
            tag.m_128405_("CastingTime", this.castingTime);
            if (!this.leakage.isEmpty()) {
                tag.m_128365_("Leakage", (Tag)this.leakage.writeToNBT(new CompoundTag()));
            }
            if (this.startCastingTime > 1) {
                tag.m_128405_("StartCastingTime", this.startCastingTime);
            }
            if (this.updateRecipes) {
                tag.m_128379_("UpdateRecipes", true);
            }
            if (!this.recipes.isEmpty() && !this.structure.isEmpty()) {
                ListTag previewList = new ListTag();
                for (CannonCastShape shape : this.structure) {
                    if (this.recipes.containsKey(shape)) {
                        BlockState state = this.recipes.get(shape).getResultBlock().m_49966_();
                        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN);
                        }
                        previewList.add((Object)NbtUtils.m_129202_((BlockState)shape.applyTo(state)));
                        continue;
                    }
                    previewList.add((Object)new CompoundTag());
                }
                tag.m_128365_("Preview", (Tag)previewList);
            }
        } else {
            tag.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        super.write(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            tag.m_128379_("ForceFluidLevel", true);
        }
        if (this.forceCastLevelUpdate) {
            tag.m_128379_("ForceCastLevel", true);
        }
        if (this.queuedSync) {
            tag.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
        this.forceCastLevelUpdate = false;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, clientPacket);
        Registry<CannonCastShape> castReg = CBCRegistries.getRegistry(CBCRegistries.CANNON_CAST_SHAPES_KEY);
        BlockPos controllerBefore = this.controllerPos;
        int prevHeight = this.getControllerTE() == null ? 0 : this.getControllerTE().height;
        CannonCastShape cannonCastShape = this.castShape = tag.m_128441_("Size") ? (CannonCastShape)castReg.m_7745_(new ResourceLocation(tag.m_128461_("Size"))) : null;
        if (tag.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastKnownPos"));
        }
        this.structure.clear();
        if (tag.m_128441_("Structure")) {
            ListTag list = tag.m_128437_("Structure", 8);
            for (int i = 0; i < list.size(); ++i) {
                CannonCastShape shape = (CannonCastShape)castReg.m_7745_(new ResourceLocation(list.m_128778_(i)));
                this.structure.add(shape == null ? (CannonCastShape)CannonCastShape.VERY_SMALL.get() : shape);
            }
            this.height = tag.m_128451_("Height");
            this.fluid.setCapacity(this.calculateCapacityFromStructure());
            this.fluid.readFromNBT(tag.m_128469_("FluidContent"));
            this.leakage = tag.m_128441_("Leakage") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Leakage")) : FluidStack.EMPTY;
            this.castingTime = Math.max(tag.m_128451_("CastingTime"), 0);
            this.startCastingTime = Math.max(tag.m_128451_("StartCastingTime"), 1);
            this.updateRecipes = tag.m_128441_("UpdateRecipes");
            this.resultPreview.clear();
            ListTag preview = tag.m_128437_("Preview", 10);
            for (int i = 0; i < preview.size(); ++i) {
                this.resultPreview.add(NbtUtils.m_129241_((CompoundTag)preview.m_128728_(i)));
            }
            this.controllerPos = null;
        } else if (tag.m_128441_("Controller")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (tag.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (tag.m_128441_("ForceCastLevel") || this.castLevel == null) {
            this.castLevel = LerpedFloat.linear().startWithValue((double)this.getCastingState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controllerPos != null : (changeOfController = !controllerBefore.equals((Object)this.controllerPos));
        if (changeOfController || this.getController() != null && prevHeight != this.getControllerTE().height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.fluid.setCapacity(this.calculateCapacityFromStructure());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (tag.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
            float castState = this.getCastingState();
            if (tag.m_128441_("ForceCastLevel") || this.castLevel == null) {
                this.castLevel = LerpedFloat.linear().startWithValue((double)castState);
            }
            this.castLevel.chase((double)castState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (tag.m_128441_("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
            this.castLevel.chase((double)this.castLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    protected void onFluidStackChanged(FluidStack stack) {
        if (!this.m_58898_()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < 3; ++xOffset) {
                for (int zOffset = 0; zOffset < 3; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    CannonCastBlockEntity castAt = (CannonCastBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (castAt == null) continue;
                    this.f_58857_.m_46717_(pos, castAt.m_58900_().m_60734_());
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    public void tick() {
        super.tick();
        this.invalidateRenderBoundingBox();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.f_58858_;
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.castLevel != null) {
            this.castLevel.tickChaser();
        }
        if (this.isController()) {
            this.tickCastingBehavior();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void tickCastingBehavior() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60767_().m_76336_()) {
            FluidStack fstack = this.fluid.drain(20, IFluidHandler.FluidAction.EXECUTE);
            if (!fstack.isEmpty()) {
                if (this.leakage.isEmpty()) {
                    this.leakage = fstack;
                } else {
                    this.leakage.setAmount(this.leakage.getAmount() + fstack.getAmount());
                }
            }
            if (this.leakage.getAmount() >= 1250) {
                Fluid leakFluid = this.leakage.getFluid();
                this.f_58857_.m_7731_(this.f_58858_.m_7495_(), leakFluid.m_76145_().m_76188_(), 11);
                this.leakage.setAmount(this.leakage.getAmount() - 1000);
            }
        } else if (this.fluid.getFluidAmount() >= this.fluid.getCapacity() && !this.fluid.isEmpty()) {
            if (this.updateRecipes) {
                this.updateRecipes();
                int oldStartCastingTime = this.startCastingTime;
                this.startCastingTime = this.calculateCastingTime();
                if (this.startCastingTime != oldStartCastingTime) {
                    this.castingTime = this.startCastingTime;
                }
                this.updateRecipes = false;
            }
            --this.castingTime;
            this.notifyUpdate();
            if (this.castingTime <= 0) {
                this.finishCasting();
                return;
            }
        } else {
            this.startCastingTime = 1;
            this.castingTime = 0;
            this.updateRecipes = true;
        }
    }

    protected void updateRecipes() {
        this.recipes.clear();
        List<BlockRecipe> list = BlockRecipeFinder.get(CASTING_RECIPES_KEY, this.f_58857_, this::matchingRecipeCache);
        list.stream().map(CannonCastingRecipe.class::cast).filter(r -> r.matches(this.f_58857_, this.f_58858_)).forEach(r -> this.recipes.put(r.shape(), (CannonCastingRecipe)r));
    }

    protected boolean matchingRecipeCache(BlockRecipe recipe) {
        return recipe instanceof CannonCastingRecipe;
    }

    protected boolean shapeMatches(CannonCastingRecipe recipe) {
        return this.structure.contains(recipe.shape());
    }

    protected int calculateCastingTime() {
        return this.structure.stream().map(this.recipes::get).map(r -> r == null ? 1200 : r.castingTime()).reduce(Integer::sum).orElse(0);
    }

    protected void finishCasting() {
        if (!this.isController() || this.structure.isEmpty()) {
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            BlockEntity blockEntity;
            BlockPos pos;
            BlockEntity blockEntity2;
            if (this.structure.size() <= y) continue;
            CannonCastingRecipe recipe = this.recipes.get(this.structure.get(y));
            if (recipe == null || !((blockEntity2 = this.f_58857_.m_7702_(pos = this.f_58858_.m_6630_(y))) instanceof CannonCastBlockEntity)) break;
            CannonCastBlockEntity cast = (CannonCastBlockEntity)blockEntity2;
            BlockPos corner = pos.m_7918_(-1, 0, -1);
            if (cast.getRenderedSize().isLarge()) {
                BlockPos.m_121990_((BlockPos)corner, (BlockPos)pos.m_7918_(1, 0, 1)).forEach(pos1 -> {
                    BlockEntity patt15494$temp;
                    if (pos.equals(pos1) || !((patt15494$temp = this.f_58857_.m_7702_(pos1)) instanceof CannonCastBlockEntity)) {
                        return;
                    }
                    CannonCastBlockEntity cast1 = (CannonCastBlockEntity)patt15494$temp;
                    cast1.m_7651_();
                    this.f_58857_.m_7731_(pos1, CBCBlocks.FINISHED_CANNON_CAST.getDefaultState(), 11);
                    BlockEntity patt15700$temp = this.f_58857_.m_7702_(pos1);
                    if (!(patt15700$temp instanceof FinishedCannonCastBlockEntity)) {
                        return;
                    }
                    FinishedCannonCastBlockEntity fCast = (FinishedCannonCastBlockEntity)patt15700$temp;
                    if (pos1.equals((Object)corner)) {
                        fCast.setRenderedShape(cast.castShape);
                        fCast.setHeight(this.height);
                        fCast.setRootBlock(this.f_58858_.m_7918_(-1, 0, -1));
                    } else {
                        fCast.setCentralBlock(corner);
                    }
                });
            }
            recipe.assembleInWorld(this.f_58857_, pos);
            if (y <= 0 || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof ICannonBlockEntity)) continue;
            ICannonBlockEntity cbe = (ICannonBlockEntity)blockEntity;
            blockEntity = this.f_58857_.m_7702_(pos.m_7495_());
            if (!(blockEntity instanceof ICannonBlockEntity)) continue;
            ICannonBlockEntity cbe1 = (ICannonBlockEntity)blockEntity;
            ((CannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(Direction.DOWN, true);
            ((CannonBehavior)((Object)cbe1.cannonBehavior())).setConnectedFace(Direction.UP, true);
        }
    }

    @Override
    public InteractionResult onWandUsed(UseOnContext context) {
        if (!this.f_58857_.f_46443_) {
            this.getControllerTE().castingTime = 0;
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
    }

    public void initializeCastMultiblock(CannonCastShape size) {
        CannonCastBlockEntity controller;
        CannonCastBlockEntity otherCast;
        this.castShape = size;
        if (this.castShape == null) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof CannonCastBlockEntity && (otherCast = (CannonCastBlockEntity)blockEntity).m_58903_() == this.m_58903_() && otherCast.getHeight() < CannonCastBlockEntity.getMaxHeight()) {
            this.controllerPos = otherCast.getController();
            controller = otherCast.getControllerTE();
            controller.fluid.setCapacity(controller.fluid.getCapacity() + this.castShape.fluidSize());
            ++controller.height;
            controller.structure.add(this.castShape);
            controller.notifyUpdate();
        } else {
            this.fluid = new SmartFluidTank(this.castShape.fluidSize(), this::onFluidStackChanged);
            this.structure.add(this.castShape);
        }
        controller = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (controller instanceof CannonCastBlockEntity && (otherCast = controller).isController()) {
            controller = this.getControllerTE();
            if (controller.height + otherCast.height <= CannonCastBlockEntity.getMaxHeight()) {
                controller.height += otherCast.height;
                controller.fluid.setCapacity(controller.fluid.getCapacity() + this.castShape.fluidSize());
                controller.fluid.fill(otherCast.fluid.drain(otherCast.fluid.getCapacity(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                controller.structure.addAll(otherCast.structure);
                otherCast.fluid = new FluidTank(1);
                otherCast.height = 1;
                otherCast.structure = new ArrayList<CannonCastShape>();
                controller.updatePotentialCastsAbove();
                controller.notifyUpdate();
            }
        }
        if (size.isLarge()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, 0, -1), (BlockPos)this.f_58858_.m_7918_(1, 0, 1))) {
                CannonCastBlockEntity childCast;
                if (pos.equals((Object)this.f_58858_)) continue;
                this.f_58857_.m_7731_(pos, CBCBlocks.CANNON_CAST.getDefaultState(), 11);
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(pos);
                if (!(blockEntity2 instanceof CannonCastBlockEntity) || (childCast = (CannonCastBlockEntity)blockEntity2).m_58903_() != this.m_58903_()) continue;
                childCast.controllerPos = this.getController();
                childCast.notifyUpdate();
            }
        }
        CannonCastBlockEntity controller2 = this.getControllerTE();
        controller2.updateRecipes = true;
        controller2.forceFluidLevelUpdate = true;
        controller2.forceCastLevelUpdate = true;
        controller2.notifyUpdate();
        this.notifyUpdate();
    }

    public void destroyCastMultiblockAtLayer() {
        if (this.canRenderCastModel() && this.castShape != null) {
            CannonCastBlockEntity controller = this.getControllerTE();
            int thisIndex = this.f_58858_.m_123342_() - controller.f_58858_.m_123342_();
            --controller.height;
            int capacityUpTo = controller.structure.subList(0, Mth.m_14045_((int)thisIndex, (int)0, (int)controller.structure.size())).stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElseGet(() -> 0);
            int leakAmount = Mth.m_14045_((int)(controller.fluid.getFluidAmount() - capacityUpTo), (int)0, (int)this.castShape.fluidSize());
            FluidStack addLeak = controller.fluid.drain(leakAmount, IFluidHandler.FluidAction.EXECUTE);
            controller.fluid.setCapacity(Math.max(1, controller.fluid.getCapacity() - this.castShape.fluidSize()));
            FluidStack remaining = controller.fluid.getFluid();
            if (controller == this && this.height > 0) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
                if (blockEntity instanceof CannonCastBlockEntity) {
                    CannonCastBlockEntity otherCast = (CannonCastBlockEntity)blockEntity;
                    otherCast.controllerPos = null;
                    otherCast.height = this.height;
                    otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.f_58857_, this.f_58858_.m_7494_(), this.height);
                    otherCast.fluid = new SmartFluidTank(otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                    otherCast.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
                    otherCast.updatePotentialCastsAbove();
                    otherCast.notifyUpdate();
                }
            } else {
                int oldHeight = controller.height;
                controller.height = thisIndex;
                controller.structure = controller.structure.subList(0, Mth.m_14045_((int)thisIndex, (int)0, (int)controller.structure.size()));
                controller.fluid = new SmartFluidTank(controller.calculateCapacityFromStructure(), controller::onFluidStackChanged);
                int firstRemaining = remaining.getAmount() - controller.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
                if (!remaining.isEmpty()) {
                    remaining.setAmount(firstRemaining);
                }
                controller.updateRecipes = true;
                controller.notifyUpdate();
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
                if (blockEntity instanceof CannonCastBlockEntity) {
                    CannonCastBlockEntity otherCast = (CannonCastBlockEntity)blockEntity;
                    otherCast.controllerPos = null;
                    otherCast.height = oldHeight - controller.height;
                    otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.f_58857_, this.f_58858_.m_7494_(), otherCast.height);
                    otherCast.fluid = new SmartFluidTank(otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                    otherCast.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
                    otherCast.updatePotentialCastsAbove();
                    otherCast.updateRecipes = true;
                    otherCast.notifyUpdate();
                }
            }
            if (this.castShape.isLarge()) {
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, 0, -1), (BlockPos)this.f_58858_.m_7918_(1, 0, 1))) {
                    if (!CBCBlocks.CANNON_CAST.has(this.f_58857_.m_8055_(pos))) continue;
                    this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                }
            }
            if (!addLeak.isEmpty() && addLeak.getAmount() >= 1000) {
                this.f_58857_.m_7731_(this.f_58858_, addLeak.getFluid().m_76145_().m_76188_(), 11);
            }
        } else {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.getCenterBlock());
            if (blockEntity instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity otherCast = (CannonCastBlockEntity)blockEntity;
                otherCast.destroyCastMultiblockAtLayer();
            }
        }
    }

    public static List<CannonCastShape> getStructureFromPoint(Level level, BlockPos pos, int height) {
        BlockEntity blockEntity;
        ArrayList<CannonCastShape> structure = new ArrayList<CannonCastShape>();
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (!(blockEntity2 instanceof CannonCastBlockEntity)) {
            return structure;
        }
        CannonCastBlockEntity start = (CannonCastBlockEntity)blockEntity2;
        pos = start.getCenterBlock();
        for (int i = 0; i < height && (blockEntity = level.m_7702_(pos)) instanceof CannonCastBlockEntity; ++i) {
            CannonCastBlockEntity cast = (CannonCastBlockEntity)blockEntity;
            structure.add(cast.castShape);
        }
        return structure;
    }

    private void updatePotentialCastsAbove() {
        BlockEntity blockEntity;
        if (!this.isController()) {
            return;
        }
        for (int y = 0; y < this.height && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_6630_(y))) instanceof CannonCastBlockEntity; ++y) {
            CannonCastBlockEntity cast = (CannonCastBlockEntity)blockEntity;
            if (y != 0) {
                cast.setController(this.f_58858_);
            }
            if (!cast.getRenderedSize().isLarge()) continue;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockEntity blockEntity2;
                    if (x == 0 && z == 0 || !((blockEntity2 = this.f_58857_.m_7702_(this.f_58858_.m_7918_(x, y, z))) instanceof CannonCastBlockEntity)) continue;
                    CannonCastBlockEntity cast1 = (CannonCastBlockEntity)blockEntity2;
                    cast1.setController(this.f_58858_);
                    cast1.m_6596_();
                }
            }
        }
    }

    public int calculateCapacityFromStructure() {
        return this.structure.stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElseGet(() -> 0);
    }

    public BlockPos getCenterBlock() {
        return this.isController() ? this.f_58858_ : new BlockPos(this.controllerPos.m_123341_(), this.f_58858_.m_123342_(), this.controllerPos.m_123343_());
    }

    public boolean canRenderCastModel() {
        return this.isController() ? true : this.controllerPos.m_123341_() == this.f_58858_.m_123341_() && this.controllerPos.m_123343_() == this.f_58858_.m_123343_();
    }

    public float getFillState() {
        return this.fluid.getCapacity() == 0 ? 0.0f : (float)this.fluid.getFluidAmount() / (float)this.fluid.getCapacity();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat level) {
        this.fluidLevel = level;
    }

    public float getCastingState() {
        return this.startCastingTime <= 1 ? 0.0f : 1.0f - (float)this.castingTime / (float)this.startCastingTime;
    }

    public LerpedFloat getCastingLevel() {
        return this.castLevel;
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controllerPos;
    }

    public CannonCastBlockEntity getControllerTE() {
        CannonCastBlockEntity cast;
        BlockEntity blockEntity;
        return this.isController() ? this : ((blockEntity = this.f_58857_.m_7702_(this.controllerPos)) instanceof CannonCastBlockEntity ? (cast = (CannonCastBlockEntity)blockEntity) : null);
    }

    public boolean isController() {
        return this.controllerPos == null || this.f_58858_.equals((Object)this.controllerPos);
    }

    public void setController(BlockPos pos) {
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual() || pos.equals((Object)this.controllerPos)) {
            return;
        }
        this.controllerPos = pos;
        this.refreshCap();
        this.notifyUpdate();
    }

    public static int getMaxHeight() {
        return (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return 3;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82386_(-1.0, 0.0, -1.0).m_82363_(2.0, (double)(this.height - 1), 2.0);
        }
        if (this.canRenderCastModel() && this.getControllerTE() != null) {
            return this.getControllerTE().createRenderBoundingBox();
        }
        return super.createRenderBoundingBox();
    }

    public CannonCastShape getRenderedSize() {
        return this.castShape;
    }

    public void removeController(boolean keepContents) {
        this.refreshCap();
        this.notifyUpdate();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
    }

    public void notifyMultiUpdated() {
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis == Direction.Axis.Y ? (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get() : 3;
    }

    public int getMaxWidth() {
        return 3;
    }

    public void setWidth(int width) {
    }
}

