/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.CBCFluids;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.datagen.recipes.BlockRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;

public class CannonCastRecipeProvider
extends BlockRecipeProvider {
    CannonCastRecipeProvider(DataGenerator gen) {
        this("createbigcannons", gen);
    }

    public CannonCastRecipeProvider(String modid, DataGenerator gen) {
        super(modid, gen);
        this.info = CreateBigCannons.resource("cannon_casting");
    }

    @Override
    protected void registerRecipes(Consumer<FinishedBlockRecipe> cons) {
        this.builder("unbored_cast_iron_cannon_barrel").castingShape((CannonCastShape)CannonCastShape.VERY_SMALL.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_CANNON_BARREL.get()).save(cons);
        this.builder("unbored_cast_iron_cannon_chamber").castingShape((CannonCastShape)CannonCastShape.MEDIUM.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_CANNON_CHAMBER.get()).castingTime(1800).save(cons);
        this.builder("cast_iron_cannon_end").castingShape((CannonCastShape)CannonCastShape.CANNON_END.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.CAST_IRON_CANNON_END.get()).castingTime(1500).save(cons);
        this.builder("unbored_cast_iron_sliding_breech").castingShape((CannonCastShape)CannonCastShape.SLIDING_BREECH.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_SLIDING_BREECH.get()).castingTime(1500).save(cons);
        TagKey bronzeTag = AllTags.forgeFluidTag((String)"molten_bronze");
        this.builder("unbored_bronze_cannon_barrel").castingShape((CannonCastShape)CannonCastShape.VERY_SMALL.get()).ingredient((TagKey<Fluid>)bronzeTag).result((Block)CBCBlocks.UNBORED_BRONZE_CANNON_BARREL.get()).save(cons);
        this.builder("unbored_bronze_cannon_chamber").castingShape((CannonCastShape)CannonCastShape.MEDIUM.get()).ingredient((TagKey<Fluid>)bronzeTag).result((Block)CBCBlocks.UNBORED_BRONZE_CANNON_CHAMBER.get()).castingTime(1800).save(cons);
        this.builder("bronze_cannon_end").castingShape((CannonCastShape)CannonCastShape.CANNON_END.get()).ingredient((TagKey<Fluid>)bronzeTag).result((Block)CBCBlocks.BRONZE_CANNON_END.get()).castingTime(1500).save(cons);
        this.builder("unbored_bronze_sliding_breech").castingShape((CannonCastShape)CannonCastShape.SLIDING_BREECH.get()).ingredient((TagKey<Fluid>)bronzeTag).result((Block)CBCBlocks.UNBORED_BRONZE_SLIDING_BREECH.get()).castingTime(1500).save(cons);
        TagKey steelTag = AllTags.forgeFluidTag((String)"molten_steel");
        this.builder("unbored_very_small_steel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.VERY_SMALL.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_VERY_SMALL_STEEL_CANNON_LAYER.get()).castingTime(2400).save(cons);
        this.builder("unbored_small_steel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.SMALL.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_SMALL_STEEL_CANNON_LAYER.get()).castingTime(3000).save(cons);
        this.builder("unbored_medium_steel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.MEDIUM.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_MEDIUM_STEEL_CANNON_LAYER.get()).castingTime(3600).save(cons);
        this.builder("unbored_large_steel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.LARGE.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_LARGE_STEEL_CANNON_LAYER.get()).castingTime(4200).save(cons);
        this.builder("unbored_very_large_steel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.VERY_LARGE.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_VERY_LARGE_STEEL_CANNON_LAYER.get()).castingTime(4800).save(cons);
        this.builder("unbored_steel_sliding_breech").castingShape((CannonCastShape)CannonCastShape.SLIDING_BREECH.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_STEEL_SLIDING_BREECH.get()).castingTime(3000).save(cons);
        this.builder("unbored_steel_screw_breech").castingShape((CannonCastShape)CannonCastShape.SCREW_BREECH.get()).ingredient((TagKey<Fluid>)steelTag).result((Block)CBCBlocks.UNBORED_STEEL_SCREW_BREECH.get()).castingTime(3000).save(cons);
        this.builder("unbored_very_small_nethersteel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.VERY_SMALL.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_VERY_SMALL_NETHERSTEEL_CANNON_LAYER.get()).castingTime(2400).save(cons);
        this.builder("unbored_small_nethersteel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.SMALL.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_SMALL_NETHERSTEEL_CANNON_LAYER.get()).castingTime(3000).save(cons);
        this.builder("unbored_medium_nethersteel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.MEDIUM.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_MEDIUM_NETHERSTEEL_CANNON_LAYER.get()).castingTime(3600).save(cons);
        this.builder("unbored_large_nethersteel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.LARGE.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_LARGE_NETHERSTEEL_CANNON_LAYER.get()).castingTime(4200).save(cons);
        this.builder("unbored_very_large_nethersteel_cannon_layer").castingShape((CannonCastShape)CannonCastShape.VERY_LARGE.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_VERY_LARGE_NETHERSTEEL_CANNON_LAYER.get()).castingTime(4800).save(cons);
        this.builder("unbored_nethersteel_screw_breech").castingShape((CannonCastShape)CannonCastShape.SCREW_BREECH.get()).ingredient((Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get()).result((Block)CBCBlocks.UNBORED_NETHERSTEEL_SCREW_BREECH.get()).castingTime(3000).save(cons);
        this.builder("unbored_cast_iron_autocannon_breech").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BREECH.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_BREECH.get()).castingTime(750).save(cons);
        this.builder("unbored_cast_iron_autocannon_recoil_spring").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_RECOIL_SPRING.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_RECOIL_SPRING.get()).castingTime(750).save(cons);
        this.builder("unbored_cast_iron_autocannon_barrel").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BARREL.get()).ingredient((Fluid)CBCFluids.MOLTEN_CAST_IRON.get()).result((Block)CBCBlocks.UNBORED_CAST_IRON_AUTOCANNON_BARREL.get()).castingTime(750).save(cons);
        this.builder("unbored_bronze_autocannon_breech").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BREECH.get()).ingredient((Fluid)CBCFluids.MOLTEN_BRONZE.get()).result((Block)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_BREECH.get()).castingTime(750).save(cons);
        this.builder("unbored_bronze_autocannon_recoil_spring").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_RECOIL_SPRING.get()).ingredient((Fluid)CBCFluids.MOLTEN_BRONZE.get()).result((Block)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_RECOIL_SPRING.get()).castingTime(750).save(cons);
        this.builder("unbored_bronze_autocannon_barrel").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BARREL.get()).ingredient((Fluid)CBCFluids.MOLTEN_BRONZE.get()).result((Block)CBCBlocks.UNBORED_BRONZE_AUTOCANNON_BARREL.get()).castingTime(750).save(cons);
        this.builder("unbored_steel_autocannon_breech").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BREECH.get()).ingredient((Fluid)CBCFluids.MOLTEN_STEEL.get()).result((Block)CBCBlocks.UNBORED_STEEL_AUTOCANNON_BREECH.get()).castingTime(1500).save(cons);
        this.builder("unbored_steel_autocannon_recoil_spring").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_RECOIL_SPRING.get()).ingredient((Fluid)CBCFluids.MOLTEN_STEEL.get()).result((Block)CBCBlocks.UNBORED_STEEL_AUTOCANNON_RECOIL_SPRING.get()).castingTime(1500).save(cons);
        this.builder("unbored_steel_autocannon_barrel").castingShape((CannonCastShape)CannonCastShape.AUTOCANNON_BARREL.get()).ingredient((Fluid)CBCFluids.MOLTEN_STEEL.get()).result((Block)CBCBlocks.UNBORED_STEEL_AUTOCANNON_BARREL.get()).castingTime(1500).save(cons);
    }

    protected Builder builder(String name) {
        return new Builder(name);
    }

    private class Builder {
        private final ResourceLocation id;
        private CannonCastShape shape = null;
        private FluidIngredient ingredient = null;
        private int castingTime = 1200;
        private Block result = null;

        private Builder(String name) {
            this.id = new ResourceLocation(CannonCastRecipeProvider.this.modid, name);
        }

        public Builder castingShape(CannonCastShape shape) {
            this.shape = shape;
            return this;
        }

        public Builder ingredient(Fluid ingredient) {
            this.ingredient = FluidIngredient.fromFluid((Fluid)ingredient, (int)1);
            return this;
        }

        public Builder ingredient(TagKey<Fluid> ingredient) {
            this.ingredient = FluidIngredient.fromTag(ingredient, (int)1);
            return this;
        }

        public Builder castingTime(int castingTime) {
            this.castingTime = castingTime;
            return this;
        }

        public Builder result(Block result) {
            this.result = result;
            return this;
        }

        public void save(Consumer<FinishedBlockRecipe> cons) {
            Objects.requireNonNull(this.shape, "Recipe " + this.id + " has no casting shape specified");
            Objects.requireNonNull(this.ingredient, "Recipe " + this.id + " has no fluid ingredient specified");
            Objects.requireNonNull(this.result, "Recipe " + this.id + " has no result specified");
            cons.accept(new Result(this.shape, this.ingredient, this.result, this.castingTime, this.id));
        }
    }

    private record Result(CannonCastShape shape, FluidIngredient ingredient, Block result, int castingTime, ResourceLocation id) implements FinishedBlockRecipe
    {
        @Override
        public void serializeRecipeData(JsonObject obj) {
            obj.addProperty("cast_shape", CBCRegistries.getRegistry(CBCRegistries.CANNON_CAST_SHAPES_KEY).m_7981_((Object)this.shape).toString());
            obj.add("fluid", (JsonElement)this.ingredient.serialize());
            obj.addProperty("casting_time", (Number)this.castingTime);
            obj.addProperty("result", Registry.f_122824_.m_7981_((Object)this.result).toString());
        }

        @Override
        public BlockRecipeSerializer<?> getSerializer() {
            return (BlockRecipeSerializer)BlockRecipeSerializer.CANNON_CASTING.get();
        }
    }
}

