/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import org.slf4j.Logger;

public class BlockHardnessProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator gen;
    protected final String modid;
    protected final String name;
    private final Map<Block, Double> blocks = new HashMap<Block, Double>();
    private final Map<TagKey<Block>, Double> tags = new HashMap<TagKey<Block>, Double>();
    private final Map<ResourceLocation, Double> locs = new HashMap<ResourceLocation, Double>();

    public BlockHardnessProvider(String modid, String name, DataGenerator gen) {
        this.modid = modid;
        this.name = name;
        this.gen = gen;
    }

    public BlockHardnessProvider(String modid, DataGenerator gen) {
        this(modid, "default", gen);
    }

    public final void m_213708_(CachedOutput cache) {
        this.registerHardnesses();
        JsonObject obj = new JsonObject();
        for (Map.Entry<Block, Double> entry : this.blocks.entrySet()) {
            obj.addProperty(Registry.f_122824_.m_7981_((Object)entry.getKey()).toString(), (Number)entry.getValue());
        }
        for (Map.Entry<Block, Double> entry : this.locs.entrySet()) {
            obj.addProperty(((ResourceLocation)entry.getKey()).toString(), (Number)entry.getValue());
        }
        for (Map.Entry<Block, Double> entry : this.tags.entrySet()) {
            obj.addProperty("#" + ((TagKey)entry.getKey()).f_203868_(), (Number)entry.getValue());
        }
        Path path = this.gen.m_123916_().resolve("data/" + this.modid + "/block_hardness/" + this.name + ".json");
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)obj, (Path)path);
        }
        catch (IOException iOException) {
            LOGGER.error("Couldn't save block hardness values to {}", (Object)path, (Object)iOException);
        }
    }

    protected void registerHardnesses() {
        this.setHardness((TagKey<Block>)Tags.Blocks.OBSIDIAN, 12.0);
        this.setHardness(Blocks.f_50723_, 12.0);
        this.setHardness((TagKey<Block>)BlockTags.f_13033_, 6.0);
    }

    protected final void setHardness(Block block, double hardness) {
        this.blocks.put(block, hardness);
    }

    protected final void setHardness(TagKey<Block> tag, double hardness) {
        this.tags.put(tag, hardness);
    }

    protected final void setHardness(ResourceLocation loc, double hardness) {
        this.locs.put(loc, hardness);
    }

    public String m_6055_() {
        return "Custom block hardness: " + this.modid;
    }
}

