/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public abstract class AbstractCannonProjectile
extends Projectile {
    protected static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> PROJECTILE_MASS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected int inGroundTime = 0;
    protected float damage = 50.0f;

    protected AbstractCannonProjectile(EntityType<? extends AbstractCannonProjectile> type, Level level) {
        super(type, level);
    }

    public void m_8119_() {
        block6: {
            Vec3 uel;
            block7: {
                block8: {
                    if (!this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(this.m_20183_())) break block6;
                    super.m_8119_();
                    if (!this.isInGround()) {
                        this.clipAndDamage();
                    }
                    this.f_19859_ = this.m_146908_();
                    this.f_19860_ = this.m_146909_();
                    if (!this.isInGround()) {
                        Vec3 vel = this.m_20184_();
                        if (vel.m_82556_() > 0.005) {
                            this.m_146922_((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                            this.m_146926_((float)(Mth.m_14136_((double)vel.f_82480_, (double)vel.m_165924_()) * 57.2957763671875));
                        }
                        this.m_146922_(AbstractCannonProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
                        this.m_146926_(AbstractCannonProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
                    }
                    if (!this.isInGround()) break block7;
                    this.m_20256_(Vec3.f_82478_);
                    if (!this.shouldFall()) break block8;
                    this.setInGround(false);
                    break block6;
                }
                if (this.f_19853_.f_46443_) break block6;
                ++this.inGroundTime;
                if (this.inGroundTime != 400) break block6;
                this.m_146870_();
                break block6;
            }
            this.inGroundTime = 0;
            Vec3 vel = uel = this.m_20184_();
            Vec3 oldPos = this.m_20182_();
            Vec3 newPos = oldPos.m_82549_(vel);
            if (!this.m_20068_()) {
                vel = vel.m_82520_(0.0, (double)this.getGravity(), 0.0);
            }
            vel = vel.m_82490_((double)this.getDrag());
            this.m_20256_(vel);
            this.m_146884_(newPos.m_82549_(vel.m_82546_(uel).m_82490_(0.5)));
            ParticleOptions particle = this.getTrailParticles();
            if (particle != null) {
                for (int i = 0; i < 10; ++i) {
                    double partial = (float)i * 0.1f;
                    double dx = Mth.m_14139_((double)partial, (double)this.f_19790_, (double)this.m_20185_());
                    double dy = Mth.m_14139_((double)partial, (double)this.f_19791_, (double)this.m_20186_());
                    double dz = Mth.m_14139_((double)partial, (double)this.f_19792_, (double)this.m_20189_());
                    this.f_19853_.m_7106_(particle, dx, dy, dz, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void clipAndDamage() {
        Vec3 start = this.m_20182_();
        Vec3 end = start.m_82549_(this.m_20184_());
        CBCCfgMunitions.GriefState flag = (CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get());
        double reach = (double)Math.max(this.m_20205_(), this.m_20206_()) * 0.5;
        AABB generalMovementRegion = this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0);
        ArrayList<Entity> hitEntities = new ArrayList<Entity>();
        for (Entity target : this.f_19853_.m_6249_((Entity)this, generalMovementRegion, this::m_5603_)) {
            AABB targetBox = target.m_20191_().m_82400_(reach);
            if (!targetBox.m_82371_(start, end).isPresent()) continue;
            hitEntities.add(target);
        }
        ProjectileContext projCtx = new ProjectileContext(this, start, end, hitEntities, flag);
        BiFunction<ProjectileContext, BlockPos, Boolean> onClip = this::onClip;
        BlockGetter.m_151361_((Vec3)start, (Vec3)end, (Object)projCtx, onClip.andThen(b -> b != false ? Integer.valueOf(1) : null), fPos -> null);
        if (!this.f_19853_.f_46443_ && flag != CBCCfgMunitions.GriefState.NO_DAMAGE) {
            Vec3 oldVel = this.m_20184_();
            for (Map.Entry<BlockPos, Float> explosion : projCtx.getQueuedExplosions().entrySet()) {
                BlockPos pos = explosion.getKey();
                this.f_19853_.m_46511_((Entity)this, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosion.getValue().floatValue(), Explosion.BlockInteraction.DESTROY);
            }
            this.m_20256_(oldVel);
        }
    }

    protected boolean onClip(ProjectileContext ctx, BlockPos pos) {
        BlockState state = this.f_19853_.m_46745_(pos).m_8055_(pos);
        VoxelShape vshape = state.m_60742_((BlockGetter)this.f_19853_, pos, ctx.collisionContext());
        BlockHitResult bResult = this.f_19853_.m_45558_(ctx.start(), ctx.end(), pos, vshape, state);
        Vec3 hitLoc = bResult == null ? Vec3.m_82539_((Vec3i)pos) : bResult.m_82450_();
        Vec3 curVel = this.m_20184_();
        double mag = curVel.m_82553_();
        double reach = (double)Math.max(this.m_20205_(), this.m_20206_()) * 0.5;
        if (!ctx.hitEntities().isEmpty()) {
            AABB currentMovementRegion = this.m_20191_().m_82369_(curVel.m_82490_(1.75 / mag)).m_82400_(1.0).m_82383_(hitLoc.m_82546_(this.m_20182_()));
            Iterator<Entity> targetIter = ctx.hitEntities().iterator();
            while (targetIter.hasNext()) {
                Entity target = targetIter.next();
                if (!currentMovementRegion.m_82381_(target.m_20191_().m_82400_(reach))) continue;
                this.onHitEntity(target);
                targetIter.remove();
            }
        }
        if (bResult != null) {
            boolean flag1 = ctx.getLastState().m_60795_();
            if (flag1 && this.tryBounceOffBlock(state, bResult)) {
                return true;
            }
            ctx.setLastState(state);
            double startMass = this.getProjectileMass();
            double curPom = startMass * mag;
            double hardness = BlockHardnessHandler.getHardness(state);
            if (ctx.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.m_60800_((BlockGetter)this.f_19853_, pos) == -1.0f || curPom < hardness) {
                this.m_146884_(hitLoc.m_82549_(curVel.m_82490_(0.03 / mag)));
                this.setInGround(true);
                this.m_20256_(Vec3.f_82478_);
                this.onFinalImpact((HitResult)bResult);
                return true;
            }
            this.onDestroyBlock(state, bResult);
            double f = this.overPenetrationPower(hardness, curPom);
            if (flag1 && f > 0.0) {
                ctx.queueExplosion(pos.m_7949_(), (float)f);
            }
        }
        return this.m_213877_();
    }

    protected double overPenetrationPower(double hardness, double curPom) {
        double f = hardness / curPom;
        return f <= 0.15 ? 2.0 - 2.0 * f : 0.0;
    }

    protected boolean tryBounceOffBlock(BlockState state, BlockHitResult result) {
        BounceType bounce = this.canBounce(state, result);
        if (bounce == BounceType.NO_BOUNCE) {
            return false;
        }
        Vec3 oldVel = this.m_20184_();
        double momentum = (double)this.getProjectileMass() * oldVel.m_82553_();
        if (bounce == BounceType.DEFLECT) {
            if (momentum > BlockHardnessHandler.getHardness(state) * 0.5) {
                Vec3 spallLoc = this.m_20182_().m_82549_(oldVel.m_82541_().m_82490_(2.0));
                this.f_19853_.m_46511_(null, spallLoc.f_82479_, spallLoc.f_82480_, spallLoc.f_82481_, 2.0f, Explosion.BlockInteraction.NONE);
            }
            SoundType sound = state.m_60827_();
            this.m_5496_(sound.m_56775_(), sound.m_56773_(), sound.m_56774_());
        }
        Vec3 normal = new Vec3(result.m_82434_().m_122432_());
        double elasticity = bounce == BounceType.RICOCHET ? 1.5 : 1.9;
        this.m_20256_(oldVel.m_82546_(normal.m_82490_(normal.m_82526_(oldVel) * elasticity)));
        return true;
    }

    protected void onFinalImpact(HitResult result) {
    }

    protected abstract void onDestroyBlock(BlockState var1, BlockHitResult var2);

    protected void onHitEntity(Entity entity) {
        if (this.getProjectileMass() <= 0.0f) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            entity.m_20256_(this.m_20184_().m_82490_((double)this.getKnockback(entity)));
            DamageSource source = this.getEntityDamage();
            entity.m_6469_(source, this.damage);
            if (!((Boolean)CBCConfigs.SERVER.munitions.invulProjectileHurt.get()).booleanValue()) {
                entity.f_19802_ = 0;
            }
            double penalty = entity.m_6084_() ? 2.0 : 0.2;
            this.setProjectileMass((float)Math.max((double)this.getProjectileMass() - penalty, 0.0));
            if (this.getProjectileMass() <= 0.0f) {
                this.onFinalImpact((HitResult)new EntityHitResult(entity));
                this.m_146870_();
            }
        }
    }

    protected DamageSource getEntityDamage() {
        return DamageSource.m_19361_((Entity)this, null).m_19380_();
    }

    protected float getKnockback(Entity target) {
        return 2.0f;
    }

    protected boolean canDeflect(BlockHitResult result) {
        return false;
    }

    protected boolean canBounceOffOf(BlockState state) {
        return AbstractCannonProjectile.isBounceableOffOf(state);
    }

    public static boolean isDeflector(BlockState state) {
        if (state.m_204336_(CBCTags.BlockCBC.DEFLECTS_SHOTS)) {
            return true;
        }
        if (state.m_204336_(CBCTags.BlockCBC.DOESNT_DEFLECT_SHOTS)) {
            return false;
        }
        Material material = state.m_60767_();
        return material == Material.f_76279_ || material == Material.f_76281_;
    }

    public static boolean isBounceableOffOf(BlockState state) {
        if (state.m_204336_(CBCTags.BlockCBC.DOESNT_BOUNCE_SHOTS)) {
            return false;
        }
        if (state.m_204336_(CBCTags.BlockCBC.BOUNCES_SHOTS)) {
            return true;
        }
        Material material = state.m_60767_();
        return material.m_76337_() && material.m_76338_() != PushReaction.DESTROY;
    }

    protected BounceType canBounce(BlockState state, BlockHitResult result) {
        if (!((Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get()).booleanValue() || this.getProjectileMass() <= 0.0f) {
            return BounceType.NO_BOUNCE;
        }
        if (!this.canBounceOffOf(state)) {
            return BounceType.NO_BOUNCE;
        }
        Vec3 oldVel = this.m_20184_();
        double mag = oldVel.m_82553_();
        if (mag < 0.2) {
            return BounceType.NO_BOUNCE;
        }
        Vec3 normal = new Vec3(result.m_82434_().m_122432_());
        double fc = normal.m_82526_(oldVel) / mag;
        if (this.canDeflect(result) && -1.0 <= fc && fc <= -0.5) {
            return BounceType.DEFLECT;
        }
        return -0.5 <= fc && fc <= 0.0 ? BounceType.RICOCHET : BounceType.NO_BOUNCE;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PROJECTILE_MASS, (Object)Float.valueOf(0.0f));
    }

    public void setInGround(boolean inGround) {
        if (inGround) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 1)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFE)));
        }
    }

    public boolean isInGround() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 1) != 0;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    @Nullable
    protected ParticleOptions getTrailParticles() {
        return null;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ProjectileMass", this.getProjectileMass());
        tag.m_128379_("InGround", this.isInGround());
        tag.m_128350_("Damage", this.damage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setProjectileMass(tag.m_128457_("ProjectileMass"));
        this.setInGround(tag.m_128471_("InGround"));
        this.damage = tag.m_128457_("Damage");
    }

    public void setProjectileMass(float power) {
        this.f_19804_.m_135381_(PROJECTILE_MASS, (Object)Float.valueOf(power));
    }

    public float getProjectileMass() {
        return CBCConfigs.SERVER.munitions.damageRestriction.get() == CBCCfgMunitions.GriefState.NO_DAMAGE ? 0.0f : ((Float)this.f_19804_.m_135370_(PROJECTILE_MASS)).floatValue();
    }

    public static void build(EntityType.Builder<? extends AbstractCannonProjectile> builder) {
        builder.setTrackingRange(16).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20719_().m_20699_(0.8f, 0.8f);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    protected float getGravity() {
        return -0.05f;
    }

    protected float getDrag() {
        return 0.99f;
    }

    public void setChargePower(float power) {
    }

    public boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !(entity instanceof Projectile);
    }

    public static enum BounceType {
        DEFLECT,
        RICOCHET,
        NO_BOUNCE;

    }
}

