/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public abstract class AbstractAutocannonProjectile
extends AbstractCannonProjectile {
    protected int ageRemaining = 60;

    protected AbstractAutocannonProjectile(EntityType<? extends AbstractAutocannonProjectile> type, Level level) {
        super(type, level);
        this.damage = 15.0f;
    }

    @Override
    protected float getKnockback(Entity target) {
        return 0.5f;
    }

    @Override
    protected double overPenetrationPower(double hardness, double curPom) {
        return 0.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46805_(this.m_20183_())) {
            --this.ageRemaining;
            if (this.ageRemaining <= 0) {
                this.expireProjectile();
            }
        }
    }

    protected void expireProjectile() {
        this.m_146870_();
    }

    public void setTracer(boolean tracer) {
        if (tracer) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 2)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFD)));
        }
    }

    @Override
    protected void onDestroyBlock(BlockState state, BlockHitResult result) {
        if (this.f_19853_ instanceof ServerLevel) {
            BlockPos pos = result.m_82425_();
            if (state.m_60800_((BlockGetter)this.f_19853_, pos) == -1.0f) {
                return;
            }
            Vec3 curVel = this.m_20184_();
            double curPom = (double)this.getProjectileMass() * curVel.m_82553_();
            double hardness = BlockHardnessHandler.getHardness(state) * 10.0;
            CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.m_7949_(), (int)Math.min(curPom, hardness), state, this.f_19853_);
            if (curPom > hardness) {
                double startMass = this.getProjectileMass();
                this.m_20256_(curVel.m_82541_().m_82490_(Math.max(curPom - hardness, 0.0) / startMass));
            } else {
                this.onFinalImpact((HitResult)result);
                this.m_146870_();
            }
        }
    }

    @Override
    protected void onFinalImpact(HitResult result) {
        super.onFinalImpact(result);
        if (!this.m_213877_()) {
            this.m_146870_();
        }
    }

    public boolean isTracer() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    protected float getDrag() {
        return 1.0f;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Tracer", this.isTracer());
        tag.m_128405_("Age", this.ageRemaining);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTracer(tag.m_128471_("Tracer"));
        this.ageRemaining = tag.m_128451_("Age");
    }

    public static void buildAutocannon(EntityType.Builder<? extends AbstractAutocannonProjectile> builder) {
        builder.setTrackingRange(16).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20719_().m_20699_(0.2f, 0.2f);
    }
}

