/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.flak;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCEntityTypes;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.Shrapnel;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class FlakAutocannonProjectile
extends AbstractAutocannonProjectile {
    private ItemStack fuze = ItemStack.f_41583_;

    public FlakAutocannonProjectile(EntityType<? extends FlakAutocannonProjectile> type, Level level) {
        super((EntityType<? extends AbstractAutocannonProjectile>)type, level);
        this.setProjectileMass(2.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.canDetonate(fz -> fz.onProjectileTick(this.fuze, this))) {
            this.detonate();
        }
    }

    @Override
    protected void expireProjectile() {
        FuzeItem fuzeItem;
        Item item = this.fuze.m_41720_();
        if (item instanceof FuzeItem && (fuzeItem = (FuzeItem)item).onProjectileExpiry(this.fuze, this)) {
            this.detonate();
        }
        super.expireProjectile();
    }

    @Override
    protected void onFinalImpact(HitResult result) {
        super.onFinalImpact(result);
        if (this.canDetonate(fz -> fz.onProjectileImpact(this.fuze, this, result))) {
            this.detonate();
        }
    }

    @Override
    protected boolean onClip(ProjectileContext ctx, BlockPos pos) {
        if (super.onClip(ctx, pos)) {
            return true;
        }
        if (this.canDetonate(fz -> fz.onProjectileClip(this.fuze, this, Vec3.m_82512_((Vec3i)pos), ctx))) {
            this.detonate();
            return true;
        }
        return false;
    }

    protected void detonate() {
        Vec3 oldDelta = this.m_20184_();
        this.f_19853_.m_46511_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction());
        this.m_20256_(oldDelta);
        int count = (Integer)CBCConfigs.SERVER.munitions.flakCount.get();
        float spread = CBCConfigs.SERVER.munitions.flakSpread.getF();
        float damage = CBCConfigs.SERVER.munitions.flakDamage.getF();
        Shrapnel.spawnShrapnelBurst(this.f_19853_, (EntityType)CBCEntityTypes.SHRAPNEL.get(), this.m_20182_(), this.m_20184_(), count, spread, damage);
        this.m_146870_();
    }

    public void setFuze(ItemStack fuze) {
        this.fuze = fuze;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.fuze != null && !this.fuze.m_41619_()) {
            tag.m_128365_("Fuze", (Tag)this.fuze.serializeNBT());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fuze = tag.m_128425_("Fuze", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Fuze")) : ItemStack.f_41583_;
    }

    protected final boolean canDetonate(Predicate<FuzeItem> cons) {
        FuzeItem fuzeItem;
        Item item;
        return !this.f_19853_.f_46443_ && this.f_19853_.m_46805_(this.m_20183_()) && (item = this.fuze.m_41720_()) instanceof FuzeItem && cons.test(fuzeItem = (FuzeItem)item);
    }
}

