/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticleData;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.Shrapnel;

public class FluidBlob
extends Shrapnel {
    public static final EntityDataSerializer<FluidStack> FLUID_STACK_SERIALIZER = new EntityDataSerializer<FluidStack>(){

        public void write(FriendlyByteBuf buf, FluidStack fluid) {
            buf.writeFluidStack(fluid);
        }

        public FluidStack read(FriendlyByteBuf buf) {
            return buf.readFluidStack();
        }

        public FluidStack copy(FluidStack fluid) {
            return fluid.copy();
        }
    };
    private static final EntityDataAccessor<Byte> BLOB_SIZE = SynchedEntityData.m_135353_(FluidBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<FluidStack> FLUID = SynchedEntityData.m_135353_(FluidBlob.class, FLUID_STACK_SERIALIZER);

    public FluidBlob(EntityType<? extends FluidBlob> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOB_SIZE, (Object)0);
        this.f_19804_.m_135372_(FLUID, (Object)FluidStack.EMPTY);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.getFluidStack().isEmpty()) {
            tag.m_128365_("Fluid", (Tag)this.getFluidStack().writeToNBT(new CompoundTag()));
        }
        tag.m_128344_("Size", this.getBlobSize());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFluidBase(tag.m_128441_("Fluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid")) : FluidStack.EMPTY);
        this.setBlobSize(tag.m_128445_("Size"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.getFluidStack().isEmpty()) {
            Vec3 vel = this.m_20184_();
            this.f_19853_.m_7106_((ParticleOptions)new FluidBlobParticleData(this.getBlobSize() / 4 + 1, this.getFluidStack().copy()), this.m_20185_(), this.m_20186_(), this.m_20189_(), vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    public FluidStack getFluidStack() {
        return (FluidStack)this.f_19804_.m_135370_(FLUID);
    }

    public void setFluidBase(FluidStack fluid) {
        this.f_19804_.m_135381_(FLUID, (Object)fluid);
    }

    public void setFluidStack(FluidStack fluid) {
        this.setFluidBase(fluid);
        this.setBlobSize((byte)(this.getFluidStack().getAmount() / FluidBlob.mbPerAoeRadius()));
    }

    protected void setBlobSize(byte size) {
        this.f_19804_.m_135381_(BLOB_SIZE, (Object)(size < 0 ? (byte)0 : size));
    }

    public byte getBlobSize() {
        return (Byte)this.f_19804_.m_135370_(BLOB_SIZE);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        FluidBlobEffectRegistry.effectOnHitBlock(this, result);
        super.m_8060_(result);
    }

    @Override
    protected void m_6532_(HitResult result) {
        FluidBlobEffectRegistry.effectOnAllHit(this, result);
        super.m_6532_(result);
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        if (result.m_82443_().m_6095_() == this.m_6095_()) {
            return;
        }
        FluidBlobEffectRegistry.effectOnHitEntity(this, result);
    }

    public AABB getAreaOfEffect(BlockPos pos) {
        return new AABB(pos).m_82400_((double)this.getBlobSize());
    }

    public static float getBlockAffectChance() {
        return CBCConfigs.SERVER.munitions.fluidBlobBlockAffectChance.getF();
    }

    protected ParticleOptions m_5967_() {
        return new AirParticleData();
    }

    @Override
    protected boolean canDestroyBlock(BlockState state) {
        return false;
    }

    @Override
    protected float getProjectileMass() {
        return 0.0f;
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    protected double getGravity() {
        return -0.3;
    }

    public static int mbPerAoeRadius() {
        return (Integer)CBCConfigs.SERVER.munitions.mbPerAoeRadius.get();
    }

    public static void registerDefaultBlobEffects() {
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76193_, FluidBlob::waterHitEntity);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76195_, FluidBlob::lavaHitEntity);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)AllFluids.POTION.get(), FluidBlob::potionHitEntity);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76193_, FluidBlob::waterHitBlock);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76195_, FluidBlob::lavaHitBlock);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)AllFluids.POTION.get(), FluidBlob::potionHitBlock);
    }

    public static void waterHitEntity(FluidStack fstack, FluidBlob blob, Level level, EntityHitResult result) {
        Entity entity = result.m_82443_();
        entity.m_20095_();
        if (!level.f_46443_) {
            FluidBlob.douseFire(entity.m_20183_(), blob, level);
        }
    }

    public static void lavaHitEntity(FluidStack ftack, FluidBlob blob, Level level, EntityHitResult result) {
        Entity entity = result.m_82443_();
        entity.m_20254_(100);
        if (!level.f_46443_) {
            FluidBlob.spawnFire(entity.m_20183_(), blob, level);
        }
    }

    public static void potionHitEntity(FluidStack fstack, FluidBlob blob, Level level, EntityHitResult result) {
        if (!level.f_46443_) {
            FluidBlob.spawnAreaEffectCloud(result.m_82443_().m_20183_(), blob, level);
        }
    }

    public static void waterHitBlock(FluidStack fstack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            FluidBlob.douseFire(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void lavaHitBlock(FluidStack ftack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            FluidBlob.spawnFire(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void potionHitBlock(FluidStack fstack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            FluidBlob.spawnAreaEffectCloud(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void douseFire(BlockPos root, FluidBlob blob, Level level) {
        float chance = FluidBlob.getBlockAffectChance();
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = new BlockPos(Math.floor(bounds.f_82288_), Math.floor(bounds.f_82289_), Math.floor(bounds.f_82290_));
        BlockPos pos2 = new BlockPos(Math.floor(bounds.f_82291_), Math.floor(bounds.f_82292_), Math.floor(bounds.f_82293_));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (chance == 0.0f || blob.f_19796_.m_188501_() > chance) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(BlockTags.f_13076_)) {
                level.m_7471_(pos, false);
                continue;
            }
            if (AbstractCandleBlock.m_151933_((BlockState)state)) {
                AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                continue;
            }
            if (!CampfireBlock.m_51319_((BlockState)state)) continue;
            level.m_5898_(null, 1009, pos, 0);
            CampfireBlock.m_152749_((Entity)blob.m_37282_(), (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void spawnFire(BlockPos root, FluidBlob blob, Level level) {
        float chance = FluidBlob.getBlockAffectChance();
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = new BlockPos(Math.floor(bounds.f_82288_), Math.floor(bounds.f_82289_), Math.floor(bounds.f_82290_));
        BlockPos pos2 = new BlockPos(Math.floor(bounds.f_82291_), Math.floor(bounds.f_82292_), Math.floor(bounds.f_82293_));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (!(chance > 0.0f) || !(level.m_213780_().m_188501_() <= chance) || !level.m_46859_(pos)) continue;
            level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
        }
    }

    public static void spawnAreaEffectCloud(BlockPos pos, FluidBlob blob, Level level) {
        CompoundTag tag = blob.getFluidStack().getTag();
        AreaEffectCloud aec = (AreaEffectCloud)EntityType.f_20476_.m_20615_(level);
        aec.m_146884_(Vec3.m_82512_((Vec3i)pos));
        aec.m_19712_((float)(blob.getBlobSize() * 2));
        aec.m_19732_(-0.5f);
        aec.m_19740_(10);
        aec.m_19738_(-aec.m_19743_() / (float)aec.m_19748_());
        aec.m_19722_(PotionUtils.m_43577_((CompoundTag)tag));
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)tag)) {
            aec.m_19716_(new MobEffectInstance(effect));
        }
        aec.m_19714_(PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000);
        level.m_7967_((Entity)aec);
    }
}

