/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBlockEntity;

public class FluidShellBlockEntity
extends FuzedBlockEntity {
    protected FluidTank tank = new SmartFluidTank(FluidShellBlockEntity.getFluidShellCapacity(), this::onFluidStackChanged);
    private LazyOptional<IFluidHandler> fluidOptional;

    public FluidShellBlockEntity(BlockEntityType<? extends FluidShellBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("FluidContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag.m_128469_("FluidContent"));
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) && this.fuze.m_41619_()) {
            return this.getFluidOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    public static int getFluidShellCapacity() {
        return (Integer)CBCConfigs.SERVER.munitions.fluidShellCapacity.get();
    }

    public LazyOptional<IFluidHandler> getFluidOptional() {
        if (this.fluidOptional == null) {
            this.fluidOptional = LazyOptional.of(() -> this.tank);
        }
        return this.fluidOptional;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
        }
    }

    protected void onFluidStackChanged(FluidStack newStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidOptional());
        return true;
    }
}

