/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.fuzes;

import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.createbigcannons.CBCItems;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;
import rbasamoyai.createbigcannons.munitions.fuzes.TimedFuzeContainer;

public class TimedFuzeItem
extends FuzeItem
implements MenuProvider {
    public TimedFuzeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onProjectileTick(ItemStack stack, AbstractCannonProjectile projectile) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("FuzeTimer")) {
            return true;
        }
        int timer = tag.m_128451_("FuzeTimer");
        tag.m_128405_("FuzeTimer", --timer);
        return timer <= 0;
    }

    @Override
    public boolean onProjectileExpiry(ItemStack stack, AbstractCannonProjectile projectile) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer && player.m_36326_()) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("FuzeTimer")) {
                tag.m_128405_("FuzeTimer", 20);
            }
            int timer = tag.m_128451_("FuzeTimer");
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> {
                buf.m_130130_(timer);
                buf.m_130055_(new ItemStack((ItemLike)this));
            });
        }
        return super.m_7203_(level, player, hand);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        ItemStack stack = player.m_21205_();
        return TimedFuzeContainer.getServerMenu(windowId, playerInv, stack);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    public static ItemStack getCreativeTabItem(int defaultFuze) {
        ItemStack stack = CBCItems.TIMED_FUZE.asStack();
        stack.m_41784_().m_128405_("FuzeTimer", defaultFuze);
        return stack;
    }

    @Override
    public void addExtraInfo(List<Component> tooltip, boolean isSneaking, ItemStack stack) {
        super.addExtraInfo(tooltip, isSneaking, stack);
        int time = stack.m_41784_().m_128451_("FuzeTimer");
        int seconds = time / 20;
        int ticks = time - seconds * 20;
        MutableComponent info = Lang.builder((String)"item").translate("createbigcannons.timed_fuze.tooltip.shell_info", new Object[]{seconds, ticks}).component();
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)info, (ChatFormatting)ChatFormatting.GRAY, (ChatFormatting)ChatFormatting.GREEN, (int)6));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        int time = stack.m_41784_().m_128451_("FuzeTimer");
        int seconds = time / 20;
        int ticks = time - seconds * 20;
        tooltip.add((Component)Lang.builder((String)"item").translate("createbigcannons.timed_fuze.tooltip.shell_info.item", new Object[]{seconds, ticks}).component());
    }
}

