/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.mob.PathingTarget;

public class ClientEventHandlers {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreRenderLiving(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            float partialTicks = event.getPartialTick();
            PoseStack matrixStack = event.getPoseStack();
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.calculateOrientation(partialTicks);
            climber.setRenderOrientation(renderOrientation);
            float verticalOffset = climber.getVerticalOffset(partialTicks);
            float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.f_82479_ * verticalOffset;
            float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.f_82480_ * verticalOffset;
            float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.f_82481_ * verticalOffset;
            matrixStack.m_85837_((double)x, (double)y, (double)z);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(renderOrientation.yaw));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(renderOrientation.pitch));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPostRenderLiving(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            float partialTicks = event.getPartialTick();
            PoseStack matrixStack = event.getPoseStack();
            MultiBufferSource bufferIn = event.getMultiBufferSource();
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.getRenderOrientation();
            if (renderOrientation != null) {
                float verticalOffset = climber.getVerticalOffset(partialTicks);
                float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.f_82479_ * verticalOffset;
                float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.f_82480_ * verticalOffset;
                float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.f_82481_ * verticalOffset;
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-renderOrientation.pitch));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-renderOrientation.yaw));
                if (Minecraft.m_91087_().m_91290_().m_114377_()) {
                    List<PathingTarget> pathingTargets;
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82400_((double)0.2f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    double rx = entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)partialTicks;
                    double ry = entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)partialTicks;
                    double rz = entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)partialTicks;
                    Vec3 movementTarget = climber.getTrackedMovementTarget();
                    if (movementTarget != null) {
                        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(movementTarget.m_7096_() - 0.25, movementTarget.m_7098_() - 0.25, movementTarget.m_7094_() - 0.25, movementTarget.m_7096_() + 0.25, movementTarget.m_7098_() + 0.25, movementTarget.m_7094_() + 0.25).m_82386_(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    if ((pathingTargets = climber.getTrackedPathingTargets()) != null) {
                        int i = 0;
                        for (PathingTarget pathingTarget : pathingTargets) {
                            BlockPos pos = pathingTarget.pos;
                            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(pos).m_82386_(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)0.15f);
                            matrixStack.m_85836_();
                            matrixStack.m_85837_((double)pos.m_123341_() + 0.5 - rx - (double)x, (double)pos.m_123342_() + 0.5 - ry - (double)y, (double)pos.m_123343_() + 0.5 - rz - (double)z);
                            matrixStack.m_85845_(pathingTarget.side.m_122424_().m_122406_());
                            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(-0.501, -0.501, -0.501, 0.501, -0.45, 0.501), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)1.0f);
                            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
                            VertexConsumer builder = bufferIn.m_6299_((RenderType)RenderType.f_110371_);
                            builder.m_85982_(matrix4f, -0.501f, -0.45f, -0.501f).m_85950_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).m_5752_();
                            builder.m_85982_(matrix4f, 0.501f, -0.45f, 0.501f).m_85950_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).m_5752_();
                            builder.m_85982_(matrix4f, -0.501f, -0.45f, 0.501f).m_85950_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).m_5752_();
                            builder.m_85982_(matrix4f, 0.501f, -0.45f, -0.501f).m_85950_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).m_5752_();
                            matrixStack.m_85849_();
                            ++i;
                        }
                    }
                    Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
                    VertexConsumer builder = bufferIn.m_6299_((RenderType)RenderType.f_110371_);
                    builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(0, 1, 1, 1).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_85982_(matrix4f, (float)orientation.normal.f_82479_ * 2.0f, (float)orientation.normal.f_82480_ * 2.0f, (float)orientation.normal.f_82481_ * 2.0f).m_85950_(1.0f, 0.0f, 1.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82386_((double)((float)orientation.normal.f_82479_ * 2.0f), (double)((float)orientation.normal.f_82480_ * 2.0f), (double)((float)orientation.normal.f_82481_ * 2.0f)).m_82400_((double)0.025f), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.m_85836_();
                    matrixStack.m_85837_((double)(-x), (double)(-y), (double)(-z));
                    matrix4f = matrixStack.m_85850_().m_85861_();
                    builder.m_85982_(matrix4f, 0.0f, entity.m_20206_() * 0.5f, 0.0f).m_6122_(0, 1, 1, 1).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_85982_(matrix4f, (float)orientation.localX.f_82479_, entity.m_20206_() * 0.5f + (float)orientation.localX.f_82480_, (float)orientation.localX.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82386_((double)((float)orientation.localX.f_82479_), (double)(entity.m_20206_() * 0.5f + (float)orientation.localX.f_82480_), (double)((float)orientation.localX.f_82481_)).m_82400_((double)0.025f), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    builder.m_85982_(matrix4f, 0.0f, entity.m_20206_() * 0.5f, 0.0f).m_6122_(0, 1, 1, 1).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_85982_(matrix4f, (float)orientation.localY.f_82479_, entity.m_20206_() * 0.5f + (float)orientation.localY.f_82480_, (float)orientation.localY.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82386_((double)((float)orientation.localY.f_82479_), (double)(entity.m_20206_() * 0.5f + (float)orientation.localY.f_82480_), (double)((float)orientation.localY.f_82481_)).m_82400_((double)0.025f), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    builder.m_85982_(matrix4f, 0.0f, entity.m_20206_() * 0.5f, 0.0f).m_6122_(0, 1, 1, 1).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    builder.m_85982_(matrix4f, (float)orientation.localZ.f_82479_, entity.m_20206_() * 0.5f + (float)orientation.localZ.f_82480_, (float)orientation.localZ.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)bufferIn.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82386_((double)((float)orientation.localZ.f_82479_), (double)(entity.m_20206_() * 0.5f + (float)orientation.localZ.f_82480_), (double)((float)orientation.localZ.f_82481_)).m_82400_((double)0.025f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.m_85849_();
                }
                matrixStack.m_85837_((double)(-x), (double)(-y), (double)(-z));
            }
        }
    }
}

