/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers;

import com.seibel.lod.core.enums.rendering.FogDrawMode;
import com.seibel.lod.core.handlers.IReflectionHandler;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionHandler
implements IReflectionHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)("DistantHorizons-" + ReflectionHandler.class.getSimpleName()));
    public static ReflectionHandler instance;
    private Field ofFogField = null;
    private final Object mcOptionsObject;
    private Boolean sodiumPresent = null;
    private boolean optifinePresent = false;

    private ReflectionHandler(Field[] optionFields, Object newMcOptionsObject) {
        this.mcOptionsObject = newMcOptionsObject;
        this.setupFogField(optionFields);
    }

    public static ReflectionHandler createSingleton(Field[] optionFields, Object newMcOptionsObject) throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = new ReflectionHandler(optionFields, newMcOptionsObject);
        return instance;
    }

    private void setupFogField(Field[] optionFields) {
        for (Field field : optionFields) {
            if (!field.getName().equals("ofFogType")) continue;
            this.optifinePresent = true;
            this.ofFogField = field;
            return;
        }
        LOGGER.info(ReflectionHandler.class.getSimpleName() + ": unable to find the Optifine fog field. If Optifine isn't installed this can be ignored.");
    }

    @Override
    public FogDrawMode getFogDrawMode() {
        if (this.ofFogField == null) {
            return FogDrawMode.FOG_ENABLED;
        }
        int returnNum = 0;
        try {
            returnNum = (Integer)this.ofFogField.get(this.mcOptionsObject);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        switch (returnNum) {
            default: {
                return FogDrawMode.FOG_ENABLED;
            }
            case 3: 
        }
        return FogDrawMode.FOG_DISABLED;
    }

    @Override
    public boolean vivecraftPresent() {
        try {
            Class.forName("org.vivecraft.provider.VRRenderer");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            LOGGER.info(ReflectionHandler.class.getSimpleName() + ": Vivecraft not detected.");
            return false;
        }
    }

    @Override
    public boolean optifinePresent() {
        return this.optifinePresent;
    }

    @Override
    public boolean sodiumPresent() {
        if (this.sodiumPresent == null) {
            try {
                Class.forName("me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer");
                this.sodiumPresent = true;
            }
            catch (ClassNotFoundException e) {
                this.sodiumPresent = false;
            }
        }
        return this.sodiumPresent;
    }
}

