/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.api.EventApi;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import forge.com.seibel.lod.common.wrappers.world.WorldWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeClientProxy {
    private final EventApi eventApi = EventApi.INSTANCE;
    private final ClientApi clientApi = ClientApi.INSTANCE;

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.eventApi.serverTickEvent();
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkEvent.Load event) {
        this.clientApi.clientChunkLoadEvent(new ChunkWrapper(event.getChunk(), (LevelReader)event.getLevel()), WorldWrapper.getWorldWrapper(event.getLevel()));
    }

    @SubscribeEvent
    public void worldSaveEvent(LevelEvent.Save event) {
        this.eventApi.worldSaveEvent();
    }

    @SubscribeEvent
    public void worldLoadEvent(LevelEvent.Load event) {
        if (Minecraft.m_91087_().f_91080_ instanceof TitleScreen) {
            return;
        }
        if (event.getLevel() != null) {
            this.eventApi.worldLoadEvent(WorldWrapper.getWorldWrapper(event.getLevel()));
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(LevelEvent.Unload event) {
        this.eventApi.worldUnloadEvent(WorldWrapper.getWorldWrapper(event.getLevel()));
    }

    @SubscribeEvent
    public void blockChangeEvent(BlockEvent event) {
        if (event.getClass() == BlockEvent.BreakEvent.class || event.getClass() == BlockEvent.EntityPlaceEvent.class || event.getClass() == BlockEvent.EntityMultiPlaceEvent.class || event.getClass() == BlockEvent.FluidPlaceBlockEvent.class || event.getClass() == BlockEvent.PortalSpawnEvent.class) {
            ChunkWrapper chunk = new ChunkWrapper(event.getLevel().m_46865_(event.getPos()), (LevelReader)event.getLevel());
            DimensionTypeWrapper dimType = DimensionTypeWrapper.getDimensionTypeWrapper(event.getLevel().m_6042_());
            this.eventApi.blockChangeEvent(chunk, dimType);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        this.clientApi.keyPressedEvent(event.getKey());
    }
}

