/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5285;
import net.minecraft.class_6832;

public class WorldGenStructFeatManager
extends class_5138 {
    final class_5281 genLevel;
    class_5285 worldGenSettings;
    class_6832 structureCheck;

    public WorldGenStructFeatManager(class_5285 worldGenSettings, class_5281 genLevel, class_6832 structureCheck) {
        super((class_1936)genLevel, worldGenSettings, structureCheck);
        this.genLevel = genLevel;
        this.worldGenSettings = worldGenSettings;
    }

    public WorldGenStructFeatManager forWorldGenRegion(class_3233 worldGenRegion) {
        if (worldGenRegion == this.genLevel) {
            return this;
        }
        return new WorldGenStructFeatManager(this.worldGenSettings, (class_5281)worldGenRegion, this.structureCheck);
    }

    private class_2791 _getChunk(int x, int z, class_2806 status) {
        if (this.genLevel == null) {
            return null;
        }
        return this.genLevel.method_8402(x, z, status, false);
    }

    public boolean method_38852(class_2338 blockPos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
        class_2791 chunk = this._getChunk(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16422);
        if (chunk == null) {
            return false;
        }
        return chunk.method_38871();
    }

    public List<class_3449> method_41035(class_1923 sectionPos, Predicate<class_3195> predicate) {
        class_2791 chunk = this._getChunk(sectionPos.field_9181, sectionPos.field_9180, class_2806.field_16422);
        if (chunk == null) {
            return List.of();
        }
        Map map = chunk.method_12179();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : map.entrySet()) {
            class_3195 configuredStructureFeature = (class_3195)entry.getKey();
            if (!predicate.test(configuredStructureFeature)) continue;
            LongSet var10002 = (LongSet)entry.getValue();
            Objects.requireNonNull(builder);
            this.method_41032(configuredStructureFeature, var10002, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<class_3449> method_38853(class_4076 sectionPos, class_3195 structure) {
        class_2791 chunk = this._getChunk(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16422);
        if (chunk == null) {
            return (List)((Object)Stream.empty());
        }
        LongSet longSet = chunk.method_12180(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        this.method_41032(structure, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Map<class_3195, LongSet> method_41037(class_2338 blockPos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
        class_2791 chunk = this._getChunk(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16422);
        if (chunk == null) {
            return (Map)((Object)Stream.empty());
        }
        return chunk.method_12179();
    }
}

