/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.journeymap.RailwayMapPlugin;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.content.coupling.CustomTrackOverlayRendering;
import com.railwayteam.railways.forge.RailwaysClientImpl;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRCommandsClient;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRPonderIndex;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.commands.SharedSuggestionProvider;

public class RailwaysClient {
    public static void init() {
        RailwaysClient.registerModelLayer(ConductorEntityModel.LAYER_LOCATION, ConductorEntityModel::createBodyLayer);
        RailwaysClient.registerModelLayer(ConductorCapModel.LAYER_LOCATION, ConductorCapModel::createBodyLayer);
        RailwaysClient.registerBuiltinPack("legacy_semaphore", "Steam 'n Rails Legacy Semaphores");
        RailwaysClient.registerBuiltinPack("green_signals", "Steam 'n Rails Green Signals");
        RailwaysClient.registerClientCommands(CRCommandsClient::register);
        CRPackets.PACKETS.registerS2CListener();
        CRPonderIndex.register();
        CRBlockPartials.init();
        CustomTrackOverlayRendering.register(CREdgePointTypes.COUPLER, CRBlockPartials.COUPLER_BOTH);
        Mods.JOURNEYMAP.executeIfInstalled(() -> RailwayMapPlugin::load);
        CRBlockPartials.registerCustomCap("Slimeist", "slimeist");
        CRBlockPartials.registerCustomCap("bosbesballon", "bosbesballon");
        CRBlockPartials.registerCustomCap("SpottyTheTurtle", "turtle");
        CRBlockPartials.registerCustomCap("RileyHighline", "rileyhighline");
        CRBlockPartials.registerCustomSkin("RileyHighline", "rileyhighline");
        CRBlockPartials.preventTiltingCap("RileyHighline");
        CRBlockPartials.registerCustomCap("TiesToetToet", "tiestoettoet");
        CRBlockPartials.preventTiltingCap("TiesToetToet");
        CRBlockPartials.registerCustomCap("LemmaEOF", "headphones");
        CRBlockPartials.preventTiltingCap("LemmaEOF");
        CRBlockPartials.registerCustomCap("To0pa", "stonks_hat");
        CRBlockPartials.registerCustomCap("Furti_Two", "stonks_hat_blue");
        CRBlockPartials.registerCustomCap("Aypierre", "stonks_hat_red");
        CRBlockPartials.preventTiltingCap("To0pa");
        CRBlockPartials.preventTiltingCap("Furti_Two");
        CRBlockPartials.preventTiltingCap("Aypierre");
        CRBlockPartials.registerCustomCap("NeonCityDrifter", "neoncitydrifter");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerClientCommands(Consumer<CommandDispatcher<SharedSuggestionProvider>> consumer) {
        RailwaysClientImpl.registerClientCommands(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayer(ModelLayerLocation layer, Supplier<LayerDefinition> definition) {
        void var1_1;
        RailwaysClientImpl.registerModelLayer(layer, (Supplier<LayerDefinition>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBuiltinPack(String id, String name) {
        void var1_1;
        RailwaysClientImpl.registerBuiltinPack(id, (String)var1_1);
    }
}

