/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ConductorToolboxLayer<T extends ConductorEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public ConductorToolboxLayer(RenderLayerParent<T, M> pRenderer) {
        super(pRenderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T conductorEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = ((ConductorEntity)((Object)conductorEntity)).getToolboxDisplayStack();
        if (itemstack.m_204117_(AllTags.AllItemTags.TOOLBOXES.tag) && ((ConductorEntity)((Object)conductorEntity)).isCarryingToolbox()) {
            MountedToolbox holder = ((ConductorEntity)((Object)conductorEntity)).getToolbox();
            BlockState blockState = ((BlockItem)itemstack.m_41720_()).m_40614_().m_49966_();
            SuperByteBuffer body = CachedBufferer.partial((PartialModel)CRBlockPartials.TOOLBOX_BODIES.get(holder.getColor()), (BlockState)blockState);
            SuperByteBuffer lid = CachedBufferer.partial((PartialModel)((PartialModel)AllBlockPartials.TOOLBOX_LIDS.get(holder.getColor())), (BlockState)blockState);
            SuperByteBuffer drawer = CachedBufferer.partial((PartialModel)AllBlockPartials.TOOLBOX_DRAWER, (BlockState)blockState);
            float lidAngle = holder.lid.getValue(partialTick);
            float drawerOffset = holder.drawers.getValue(partialTick);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85837_(-0.5, -1.2, -0.94);
            double rotate = 0.0;
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110457_());
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)body.centre()).rotateY(rotate)).unCentre()).translate(0.0, 0.375, 0.75).translate(0.0, -0.375, -0.75).light(packedLight).renderInto(poseStack, builder);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)lid.centre()).rotateY(rotate)).unCentre()).translate(0.0, 0.375, 0.75).rotateX((double)(60.0f * lidAngle))).translate(0.0, -0.375, -0.75).light(packedLight).renderInto(poseStack, builder);
            for (int offset : Iterate.zeroAndOne) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)drawer.centre()).rotateY(rotate)).unCentre()).translate(0.0, (double)((float)offset / 8.0f), (double)(-drawerOffset * 0.175f * (float)(2 - offset))).light(packedLight).renderInto(poseStack, builder);
            }
            poseStack.m_85849_();
        }
    }
}

