/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.track_api.TrackMaterial;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SlabUseOnCurvePacket
implements C2SPacket {
    private BlockPos pos;
    private BlockPos targetPos;
    private BlockPos soundSource;

    public SlabUseOnCurvePacket(BlockPos pos, BlockPos targetPos, BlockPos soundSource) {
        this.pos = pos;
        this.targetPos = targetPos;
        this.soundSource = soundSource;
    }

    public SlabUseOnCurvePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.targetPos = buffer.m_130135_();
        this.soundSource = buffer.m_130135_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.targetPos);
        buffer.m_130064_(this.soundSource);
    }

    @Override
    public void handle(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        if (!this.pos.m_123314_((Vec3i)player.m_20183_(), 64.0)) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(this.pos);
        if (tileEntity instanceof TrackTileEntity) {
            TrackTileEntity track = (TrackTileEntity)tileEntity;
            this.applySettings(player, track);
            track.notifyUpdate();
        }
    }

    private InteractionResult useOn(ServerPlayer player, InteractionHand hand, Level world, IHasTrackCasing casingAble) {
        SlabBlock currentCasing;
        BlockItem blockItem;
        if (world.f_46443_) {
            return InteractionResult.FAIL;
        }
        ItemStack handStack = player.m_21120_(hand);
        Item item = handStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof SlabBlock) {
            SlabBlock slabBlock = (SlabBlock)item;
            currentCasing = casingAble.getTrackCasing();
            if (currentCasing == slabBlock) {
                casingAble.setAlternate(!casingAble.isAlternate());
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                handStack.m_41774_(1);
                if (currentCasing != null) {
                    ItemStack casingStack = new ItemStack((ItemLike)currentCasing);
                    EntityUtils.givePlayerItem((Player)player, casingStack);
                }
                player.m_21008_(hand, handStack);
            }
            casingAble.setTrackCasing(slabBlock);
            return InteractionResult.SUCCESS;
        }
        if (handStack.m_41619_() && (currentCasing = casingAble.getTrackCasing()) != null) {
            handStack = new ItemStack((ItemLike)currentCasing);
            casingAble.setTrackCasing(null);
            if (!player.m_7500_()) {
                EntityUtils.givePlayerItem((Player)player, handStack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void applySettings(ServerPlayer player, TrackTileEntity te) {
        if (!te.m_58899_().m_123314_((Vec3i)player.m_20183_(), 128.0)) {
            Railways.LOGGER.warn(player.m_6302_() + " too far away from slabbed Curve track");
            return;
        }
        Level level = te.m_58904_();
        BezierConnection bezierConnection = (BezierConnection)te.getConnections().get(this.targetPos);
        if (((IHasTrackMaterial)bezierConnection).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
            Railways.LOGGER.warn(player.m_6302_() + "tried to slab a monorail track");
            return;
        }
        if (level != null) {
            InteractionHand hand = InteractionHand.MAIN_HAND;
            InteractionResult result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            if (!result.m_19077_()) {
                hand = InteractionHand.OFF_HAND;
                result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            }
            if (result.m_19080_()) {
                player.m_21011_(hand, true);
            }
            te.notifyUpdate();
        }
    }
}

