/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.schedule;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICustomExecutableInstruction;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.IRedstoneLinkable;
import com.simibubi.create.content.logistics.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneLinkInstruction
extends ScheduleInstruction
implements ICustomExecutableInstruction {
    public static WorldAttached<List<CustomRedstoneActor>> customActors = new WorldAttached($ -> new ArrayList());
    public Couple<RedstoneLinkNetworkHandler.Frequency> freq = Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);

    public static void tick(Level world) {
        List actors = (List)customActors.get((LevelAccessor)world);
        Iterator actorIterator = actors.iterator();
        while (actorIterator.hasNext()) {
            CustomRedstoneActor actor = (CustomRedstoneActor)actorIterator.next();
            actor.decrement();
            if (actor.isAlive()) continue;
            Create.REDSTONE_LINK_NETWORK_HANDLER.removeFromNetwork((LevelAccessor)world, (IRedstoneLinkable)actor);
            actorIterator.remove();
        }
    }

    public RedstoneLinkInstruction() {
        this.data.m_128405_("Power", 15);
    }

    public int slotsTargeted() {
        return 2;
    }

    public boolean supportsConditions() {
        return false;
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)this.icon(), (Object)this.formatted());
    }

    private MutableComponent formatted() {
        return Components.translatable((String)"railways.schedule.instruction.redstone_link.power", (Object[])new Object[]{this.intData("Power")});
    }

    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect((String)(slot == 0 ? "logistics.firstFrequency" : "logistics.secondFrequency"), (Object[])new Object[0]).m_130940_(ChatFormatting.RED));
    }

    private ItemStack icon() {
        return new ItemStack((ItemLike)AllBlocks.REDSTONE_LINK.get());
    }

    public ResourceLocation getId() {
        return Railways.asResource("redstone_link");
    }

    public ItemStack getSecondLineIcon() {
        return this.icon();
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.redstone_link.frequency_powered", (Object[])new Object[0]), (Object)Components.literal((String)" #1 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getFirst()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)), (Object)Components.literal((String)" #2 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getSecond()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
    }

    public void setItem(int slot, ItemStack stack) {
        this.freq.set(slot == 0, (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack));
        super.setItem(slot, stack);
    }

    public ItemStack getItem(int slot) {
        return ((RedstoneLinkNetworkHandler.Frequency)this.freq.get(slot == 0)).getStack();
    }

    protected void writeAdditional(CompoundTag tag) {
        tag.m_128365_("Frequency", (Tag)this.freq.serializeEach(f -> f.getStack().m_41739_(new CompoundTag())));
    }

    protected void readAdditional(CompoundTag tag) {
        this.freq = tag.m_128425_("Frequency", 9) ? Couple.deserializeEach((ListTag)tag.m_128437_("Frequency", 10), c -> RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)c))) : Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(20, 101, (si, l) -> si.withRange(1, 16).withStepFunction(c -> c.shift ? 5 : 1).titled(Components.translatable((String)"railways.schedule.instruction.redstone_link.power_edit_box")), "Power");
    }

    @Override
    public void execute(ScheduleRuntime runtime) {
        Train train = ((AccessorScheduleRuntime)runtime).getTrain();
        CarriageContraptionEntity cce = ((Carriage)train.carriages.get(0)).anyAvailableEntity();
        if (cce != null) {
            Level level = cce.f_19853_;
            CustomRedstoneActor actor = new CustomRedstoneActor(runtime);
            Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)level, (IRedstoneLinkable)actor);
            ((List)customActors.get((LevelAccessor)level)).add(actor);
        }
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
    }

    private final class CustomRedstoneActor
    implements IRedstoneLinkable {
        private long ticks = 8L;
        private final ScheduleRuntime runtime;

        private CustomRedstoneActor(ScheduleRuntime runtime) {
            this.runtime = runtime;
        }

        public void decrement() {
            --this.ticks;
        }

        public int getTransmittedStrength() {
            return this.isAlive() ? RedstoneLinkInstruction.this.intData("Power") : 0;
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public boolean isAlive() {
            return this.ticks > 0L;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return RedstoneLinkInstruction.this.freq;
        }

        public BlockPos getLocation() {
            return new BlockPos(((Carriage)((AccessorScheduleRuntime)this.runtime).getTrain().carriages.get(0)).getLeadingPoint().getPosition());
        }
    }
}

