/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.railwayteam.railways.Railways;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CRIcons
extends AllIcons {
    public static final ResourceLocation ICON_ATLAS = Railways.asResource("textures/gui/icons.png");
    public static final int ICON_ATLAS_SIZE = 256;
    private static int x = 0;
    private static int y = -1;
    private int iconX;
    private int iconY;
    public static final CRIcons I_SEARCH_DOWN = CRIcons.newRow();
    public static final CRIcons I_SEARCH_UP = CRIcons.next();
    public static final CRIcons I_COUPLING_BOTH = CRIcons.newRow();
    public static final CRIcons I_COUPLING_COUPLE = CRIcons.next();
    public static final CRIcons I_COUPLING_DECOUPLE = CRIcons.next();
    public static final CRIcons I_DOOR_MANUAL = CRIcons.newRow();
    public static final CRIcons I_DOOR_AUTO = CRIcons.next();
    public static final CRIcons I_DOOR_STATION_RIGHT = CRIcons.next();
    public static final CRIcons I_DOOR_STATION_LEFT = CRIcons.next();
    public static final CRIcons I_STATION_OPEN_LEFT = CRIcons.newRow();
    public static final CRIcons I_STATION_OPEN_RIGHT = CRIcons.next();

    public CRIcons(int x, int y) {
        super(x, y);
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static CRIcons next() {
        return new CRIcons(++x, y);
    }

    private static CRIcons newRow() {
        x = 0;
        return new CRIcons(0, ++y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_ATLAS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack, int x, int y) {
        this.bind();
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)x, (int)y, (int)0, (float)this.iconX, (float)this.iconY, (int)16, (int)16, (int)256, (int)256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack, int x, int y, GuiComponent component) {
        this.bind();
        component.m_93228_(matrixStack, x, y, this.iconX, this.iconY, 16, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110500_((ResourceLocation)ICON_ATLAS));
        Matrix4f matrix = ms.m_85850_().m_85861_();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / 256.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 256.0f;
        float v1 = (float)this.iconY * 1.0f / 256.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 256.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.m_85982_(matrix, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public DelegatedStencilElement asStencil() {
        return (DelegatedStencilElement)new DelegatedStencilElement().withStencilRenderer((ms, w, h, alpha) -> this.render(ms, 0, 0)).withBounds(16, 16);
    }
}

