/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmberParticle
extends TextureSheetParticle {
    protected static final float BLINK_STEP = 0.2f;
    private final SpriteSet spriteProvider;
    protected float nextAlphaGoal;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;

    public EmberParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.f_107225_ = 100;
        this.f_107219_ = true;
        this.m_108339_(spriteProvider);
        this.f_107230_ = 0.0f;
        this.nextAlphaGoal = 1.0f;
        this.f_107663_ = 0.01f;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.41568628f;
        this.f_107229_ = 0.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternion quaternion2;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_90591_();
        } else {
            quaternion2 = new Quaternion(camera.m_90591_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.m_80148_(Vector3f.f_122227_.m_122270_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.m_122251_(quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.m_122251_(quaternion2);
            Vec3f2.m_122261_(j);
            Vec3f2.m_122272_(f, g, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        float a = Math.min(1.0f, Math.max(0.0f, this.f_107230_));
        vertexConsumer.m_5483_((double)Vec3fs[0].m_122239_(), (double)Vec3fs[0].m_122260_(), (double)Vec3fs[0].m_122269_()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].m_122239_(), (double)Vec3fs[1].m_122260_(), (double)Vec3fs[1].m_122269_()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].m_122239_(), (double)Vec3fs[2].m_122260_(), (double)Vec3fs[2].m_122269_()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].m_122239_(), (double)Vec3fs[3].m_122260_(), (double)Vec3fs[3].m_122269_()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        for (int i = 0; i < 5; ++i) {
            Block blockUnder = this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_ - (double)i, this.f_107214_)).m_60734_();
            if (blockUnder instanceof CampfireBlock || blockUnder instanceof FireBlock) {
                this.f_107216_ += (double)(0.01f / (float)(i + 1));
                break;
            }
            this.f_107216_ = Math.max(this.f_107216_ - (double)0.001f, (double)0.05f);
        }
        if (this.f_107224_++ >= this.f_107225_) {
            if (this.f_107230_ <= 0.0f) {
                this.m_107274_();
            } else {
                this.f_107230_ -= 0.1f;
            }
        } else {
            this.f_107230_ += 0.1f;
        }
        if (this.nextAlphaGoal > this.f_107230_) {
            this.f_107230_ = Math.min(this.f_107230_ + 0.2f, 1.0f);
        } else if (this.nextAlphaGoal < this.f_107230_) {
            this.f_107230_ = Math.max(this.f_107230_ - 0.2f, 0.0f);
        }
        this.targetChangeCooldown -= new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.f_107209_, this.f_107210_, this.f_107211_) < 0.0125 ? 10 : 1;
        if (this.f_107208_.m_46467_() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
            this.selectBlockTarget();
        }
        Vec3 targetVector = new Vec3(this.xTarget - this.f_107212_, this.yTarget - this.f_107213_, this.zTarget - this.f_107214_);
        double length = targetVector.m_82553_();
        targetVector = targetVector.m_82490_(0.1 / length);
        this.f_107215_ = 0.3 * this.f_107215_ + 0.1 * targetVector.f_82479_ * 3.0;
        this.f_107217_ = 0.3 * this.f_107217_ + 0.1 * targetVector.f_82481_ * 3.0;
        if (!new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_).equals((Object)this.getTargetPosition())) {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    private void selectBlockTarget() {
        double groundLevel = 0.0;
        for (int i = 0; i < 20; ++i) {
            BlockState checkedBlock = this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_ - (double)i, this.f_107214_));
            if (!checkedBlock.m_60734_().m_5568_()) {
                groundLevel = this.f_107213_ - (double)i;
            }
            if (groundLevel != 0.0) break;
        }
        this.xTarget = this.f_107212_ + this.f_107223_.m_188583_();
        this.yTarget = this.f_107213_ + this.f_107223_.m_188583_() * 5.0;
        this.zTarget = this.f_107214_ + this.f_107223_.m_188583_();
        this.targetChangeCooldown = this.f_107223_.m_188502_() % 10;
    }

    public BlockPos getTargetPosition() {
        return new BlockPos(this.xTarget, this.yTarget, this.zTarget);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new EmberParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

