/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiChildControl {
    public final GuiControl control;
    public Rect rect;

    public GuiChildControl(GuiControl control) {
        this.control = control;
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
    }

    public int getX() {
        return (int)this.rect.minX;
    }

    public void setX(int x) {
        int width = this.getWidth();
        this.rect.minX = x;
        this.rect.maxX = x + width;
    }

    public int getY() {
        return (int)this.rect.minY;
    }

    public void setY(int y) {
        int height = this.getHeight();
        this.rect.minY = y;
        this.rect.maxY = y + height;
    }

    public int getWidth() {
        return (int)this.rect.getWidth();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    public int getContentWidth() {
        return (int)this.rect.getWidth() - this.control.getContentOffset() * 2;
    }

    public int getContentHeight() {
        return (int)this.rect.getHeight() - this.control.getContentOffset() * 2;
    }

    public void setWidth(int width) {
        int max;
        int min = this.getMinWidth();
        if (min != -1) {
            width = Math.max(width, min);
        }
        if ((max = this.getMaxWidth()) != -1) {
            width = Math.min(width, max);
        }
        this.rect.maxX = this.rect.minX + (double)width;
    }

    public void setHeight(int height) {
        int max;
        int min = this.getMinHeight();
        if (min != -1) {
            height = Math.max(height, min);
        }
        if ((max = this.getMaxHeight()) != -1) {
            height = Math.min(height, max);
        }
        this.rect.maxY = this.rect.minY + (double)height;
    }

    public int addWidth(int additional) {
        int before = this.getWidth();
        this.setWidth(this.getWidth() + additional);
        return this.getWidth() - before;
    }

    public int addHeight(int additional) {
        int before = this.getHeight();
        this.setHeight(this.getHeight() + additional);
        return this.getHeight() - before;
    }

    public boolean isMaxWidth() {
        if (this.getMaxWidth() != -1) {
            return this.getWidth() >= this.getMaxWidth();
        }
        return false;
    }

    public boolean isMaxHeight() {
        if (this.getMaxHeight() != -1) {
            return this.getHeight() >= this.getMaxHeight();
        }
        return false;
    }

    public int getMinWidth() {
        int min = this.control.getMinWidth();
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxWidth() {
        int max = this.control.getMaxWidth();
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredWidth() {
        return this.control.getPreferredWidth() + this.control.getContentOffset() * 2;
    }

    public int getMinHeight() {
        int min = this.control.getMinHeight(this.getContentWidth());
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxHeight() {
        int max = this.control.getMaxHeight(this.getContentWidth());
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredHeight() {
        return this.control.getPreferredHeight(this.getContentWidth()) + this.control.getContentOffset() * 2;
    }

    public void flowX() {
        this.control.flowX(this.getContentWidth(), this.control.preferredWidth());
    }

    public void flowY() {
        int width = this.getContentWidth();
        this.control.flowY(width, this.getContentHeight(), this.control.preferredHeight(width));
    }

    public int getBottom() {
        return (int)this.rect.maxY;
    }

    public boolean isMouseOver(double x, double y) {
        return this.rect.inside(x, y);
    }
}

