/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import team.creative.creativecore.common.util.filter.FilterSerializer;

@FunctionalInterface
public interface Filter<T> {
    public static final FilterSerializer SERIALIZER = new FilterSerializer();

    public boolean is(T var1);

    public static <T> Filter<T> and(Filter<T> ... filters) {
        return new FilterAnd<T>(filters);
    }

    public static <T> Filter<T> or(Filter<T> ... filters) {
        return new FilterOr<T>(filters);
    }

    public static <T> Filter<T> not(Filter<T> filter) {
        return new FilterNot<T>(filter);
    }

    public static class FilterAnd<T>
    implements Filter<T> {
        public final Filter<T>[] filters;

        public FilterAnd(Filter<T> ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean is(T t) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].is(t)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FilterOr<T>
    implements Filter<T> {
        public final Filter<T>[] filters;

        public FilterOr(Filter<T> ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean is(T t) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].is(t)) continue;
                return true;
            }
            return false;
        }
    }

    public static class FilterNot<T>
    implements Filter<T> {
        public final Filter<T> filter;

        public FilterNot(Filter<T> filter) {
            this.filter = filter;
        }

        @Override
        public boolean is(T t) {
            return !this.filter.is(t);
        }
    }
}

