/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class InventoryUtils {
    public static CompoundTag save(SimpleContainer basic) {
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < basic.m_6643_(); ++i) {
            if (basic.m_8020_(i).m_41619_()) continue;
            nbt.m_128365_("s" + i, (Tag)basic.m_8020_(i).m_41739_(nbt));
        }
        nbt.m_128405_("size", basic.m_6643_());
        return nbt;
    }

    public static SimpleContainer load(CompoundTag nbt) {
        return InventoryUtils.load(nbt, nbt.m_128451_("size"));
    }

    public static SimpleContainer load(CompoundTag nbt, int length) {
        SimpleContainer basic = new SimpleContainer(length);
        for (int i = 0; i < length; ++i) {
            if (nbt.m_128441_("s" + i)) {
                basic.m_6836_(i, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("s" + i)));
                continue;
            }
            basic.m_6836_(i, ItemStack.f_41583_);
        }
        return basic;
    }

    public static boolean isItemStackEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.m_41619_() && stackB.m_41619_()) {
            return true;
        }
        if (stackA.m_41619_() || stackB.m_41619_()) {
            return false;
        }
        if (stackA.m_41720_() != stackB.m_41720_()) {
            return false;
        }
        return stackA.areShareTagsEqual(stackB) && stackA.areCapsCompatible((CapabilityProvider)stackB);
    }

    public static boolean consumeItemStack(Container inventory, ItemStack stack) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.m_8020_(i), stack)) continue;
            int amount = Math.min(stack.m_41613_(), inventory.m_8020_(i).m_41613_());
            if (amount > 0) {
                inventory.m_8020_(i).m_41774_(amount);
                stack.m_41774_(amount);
            }
            if (!stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static boolean addItemStackToInventory(Container inventory, ItemStack stack) {
        int i;
        for (i = 0; i < inventory.m_6643_(); ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory.m_8020_(i), stack) || (amount = Math.min(stack.m_41741_() - inventory.m_8020_(i).m_41613_(), stack.m_41613_())) <= 0) continue;
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(inventory.m_8020_(i).m_41613_() + amount);
            inventory.m_6836_(i, newStack);
            stack.m_41774_(amount);
            if (!stack.m_41619_()) continue;
            return true;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            inventory.m_6836_(i, stack);
            return true;
        }
        return false;
    }

    public static int getAmount(Container inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.m_8020_(i), stack)) continue;
            amount += inventory.m_8020_(i).m_41613_();
        }
        return amount;
    }

    public static void cleanInventory(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack == null || !stack.m_41619_()) continue;
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public static int consume(CreativeIngredient info, Container inventory) {
        return InventoryUtils.consume(info, inventory, null);
    }

    public static int consume(CreativeIngredient info, Container inventory, ArrayList<ItemStack> consumed) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int stackSize = 1;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !info.is(stack)) continue;
            int used = Math.min(stackSize, stack.m_41613_());
            stack.m_41774_(used);
            ItemStack stackCopy = stack.m_41777_();
            stackCopy.m_41764_(used);
            stacks.add(stackCopy);
            if ((stackSize -= used) <= 0) break;
        }
        if (consumed != null) {
            consumed.addAll(stacks);
        }
        return stackSize;
    }

    public static void sortInventory(Container inventory, boolean alphabetical) {
        int i;
        ArrayList<ItemStack> sorting = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < inventory.m_6643_(); ++i2) {
            ItemStack stack = inventory.m_8020_(i2);
            if (stack.m_41619_()) continue;
            sorting.add(stack);
        }
        if (alphabetical) {
            Collections.sort(sorting, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack arg0, ItemStack arg1) {
                    return ForgeRegistries.ITEMS.getKey((Object)arg0.m_41720_()).toString().compareToIgnoreCase(ForgeRegistries.ITEMS.getKey((Object)arg1.m_41720_()).toString());
                }
            });
        } else {
            Collections.sort(sorting, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack arg0, ItemStack arg1) {
                    int id1;
                    int id0 = Item.m_41393_((Item)arg0.m_41720_());
                    if (id0 < (id1 = Item.m_41393_((Item)arg1.m_41720_()))) {
                        return -1;
                    }
                    if (id0 > id1) {
                        return 1;
                    }
                    if (arg0.m_41773_() < arg1.m_41773_()) {
                        return -1;
                    }
                    if (arg0.m_41773_() > arg1.m_41773_()) {
                        return 1;
                    }
                    return ForgeRegistries.ITEMS.getKey((Object)arg0.m_41720_()).toString().compareToIgnoreCase(ForgeRegistries.ITEMS.getKey((Object)arg1.m_41720_()).toString());
                }
            });
        }
        int maxStackSize = inventory.m_6893_();
        for (i = 0; i < sorting.size() - 1; ++i) {
            int maxStack;
            int use;
            ItemStack stack1;
            ItemStack stack0 = (ItemStack)sorting.get(i);
            if (!InventoryUtils.isItemStackEqual(stack0, stack1 = (ItemStack)sorting.get(i + 1)) || (use = Math.min((maxStack = Math.min(maxStackSize, stack0.m_41741_())) - stack0.m_41613_(), stack1.m_41613_())) <= 0) continue;
            stack0.m_41769_(use);
            stack1.m_41774_(use);
            if (stack1.m_41619_()) {
                sorting.remove(i + 1);
            }
            --i;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            inventory.m_6836_(i, i < sorting.size() ? (ItemStack)sorting.get(i) : ItemStack.f_41583_);
        }
    }

    public static String toString(Container inventory) {
        Object result = "[";
        boolean first = true;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (first) {
                first = false;
            } else {
                result = (String)result + ",";
            }
            result = (String)result + stack.toString();
        }
        return (String)result + "]";
    }
}

