/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.list.Tuple;

public class TupleList<K, V>
extends ArrayList<Tuple<K, V>> {
    protected Iterable<K> keys = new Iterable<K>(){

        @Override
        public Iterator<K> iterator() {
            return new FunctionIterator<Object>(TupleList.this, x -> x.key);
        }
    };
    protected Iterable<V> values = new Iterable<V>(){

        @Override
        public Iterator<V> iterator() {
            return new FunctionIterator<Object>(TupleList.this, x -> x.value);
        }
    };

    public TupleList() {
    }

    public TupleList(List<Tuple<K, V>> list) {
        super(list);
    }

    public boolean add(K key, V value) {
        return this.add(new Tuple<K, V>(key, value));
    }

    public boolean containsKey(K key) {
        return this.indexOfKey(key) != -1;
    }

    public int indexOfKey(K key) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Tuple)this.get((int)i)).key.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public Iterable<V> values() {
        return this.values;
    }

    public Iterable<K> keys() {
        return this.keys;
    }

    @Override
    public Tuple<K, V> getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (Tuple)this.get(0);
    }

    @Override
    public Tuple<K, V> getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (Tuple)this.get(this.size() - 1);
    }

    @Nullable
    public V findValue(K key) {
        Tuple<K, V> tuple = this.findTuple(key);
        if (tuple != null) {
            return tuple.value;
        }
        return null;
    }

    @Nullable
    public Tuple<K, V> findTuple(K key) {
        int index = this.indexOfKey(key);
        if (index != -1) {
            return (Tuple)this.get(index);
        }
        return null;
    }
}

