/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.entity.fast_retrieval;

import java.util.function.Consumer;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={EntitySectionStorage.class})
public abstract class EntitySectionStorageMixin<T extends EntityAccess> {
    @Shadow
    @Nullable
    public abstract EntitySection<T> m_156895_(long var1);

    @Inject(method={"forEachAccessibleNonEmptySection"}, at={@At(value="INVOKE_ASSIGN", shift=At.Shift.AFTER, target="Lnet/minecraft/core/SectionPos;posToSectionCoord(D)I", ordinal=5)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void forEachInBox(AABB box, Consumer<EntitySection<T>> action, CallbackInfo ci, int i, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (maxX >= minX + 4 || maxZ >= minZ + 4) {
            return;
        }
        ci.cancel();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = Math.max(minZ, 0); z <= maxZ; ++z) {
                this.forEachInColumn(x, minY, maxY, z, action);
            }
            int bound = Math.min(-1, maxZ);
            for (int z = minZ; z <= bound; ++z) {
                this.forEachInColumn(x, minY, maxY, z, action);
            }
        }
    }

    private void forEachInColumn(int x, int minY, int maxY, int z, Consumer<EntitySection<T>> action) {
        for (int y = Math.max(minY, 0); y <= maxY; ++y) {
            this.consumeSection(SectionPos.m_123209_((int)x, (int)y, (int)z), action);
        }
        int bound = Math.min(-1, maxY);
        for (int y = minY; y <= bound; ++y) {
            this.consumeSection(SectionPos.m_123209_((int)x, (int)y, (int)z), action);
        }
    }

    private void consumeSection(long pos, Consumer<EntitySection<T>> action) {
        EntitySection<T> section = this.m_156895_(pos);
        if (section != null && 0 != section.m_156849_() && section.m_156848_().m_157694_()) {
            action.accept(section);
        }
    }
}

