/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.util;

import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuzzlesUtil {
    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static <T> boolean runOrElse(@NotNull T object, Consumer<T> action, Consumer<T> orElse) {
        try {
            action.accept(object);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Unable to handle object {}: {}", (Object)object.getClass().getSimpleName(), (Object)e.getMessage());
            orElse.accept(object);
            return false;
        }
        return true;
    }

    public static <T> boolean acceptIfPresent(@Nullable T object, Consumer<T> action) {
        if (object != null) {
            action.accept(object);
            return true;
        }
        return false;
    }

    public static <T> T getOrElse(@Nullable T instance, Supplier<T> supplier, Consumer<T> consumer) {
        if (instance == null) {
            instance = supplier.get();
            consumer.accept(instance);
        }
        return instance;
    }

    @Nullable
    public static <T> T getRandomEntry(Collection<T> collection, Function<T, Integer> weight) {
        if (!collection.isEmpty()) {
            int totalWeight = (int)((double)collection.stream().map(weight).mapToInt(Integer::intValue).sum() * Math.random());
            for (T entry : collection) {
                if ((totalWeight -= weight.apply(entry).intValue()) >= 0) continue;
                return entry;
            }
        }
        return null;
    }

    public static double round(double toRound, int decimalPlaces) {
        double power = Math.pow(10.0, decimalPlaces);
        return (double)Math.round(toRound * power) / power;
    }

    public static <T> T loadServiceProvider(Class<T> clazz) {
        return ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
    }
}

