/*
 * Decompiled with CFR 0.152.
 */
package net.sydokiddo.auditory.mixin.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.sydokiddo.auditory.Auditory;
import net.sydokiddo.auditory.sound.ModSoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JukeboxBlock.class})
public abstract class JukeboxDiscSoundMixin
extends BaseEntityBlock {
    protected JukeboxDiscSoundMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"use"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/gameevent/GameEvent;JUKEBOX_STOP_PLAY:Lnet/minecraft/world/level/gameevent/GameEvent;")})
    private void auditory_ejectDiscSound(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (Auditory.getConfig().block_sounds.jukebox_sounds) {
            level.m_5594_(player, blockPos, (SoundEvent)ModSoundEvents.BLOCK_JUKEBOX_EJECT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        }
    }

    @Inject(method={"setRecord"}, at={@At(value="HEAD")})
    private void auditory_insertDiscSound(Entity entity, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, ItemStack itemStack, CallbackInfo ci) {
        if (Auditory.getConfig().block_sounds.jukebox_sounds) {
            levelAccessor.m_5594_(null, blockPos, (SoundEvent)ModSoundEvents.BLOCK_JUKEBOX_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

