/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin.instancemanage;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.mixin.instancemanage.RenderChunkAccessor;
import com.jozufozu.flywheel.util.RenderChunkExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(targets={"net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk$RebuildTask"})
public abstract class ChunkRebuildHooksMixin {
    @Unique
    private Level flywheel$level;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk;Lnet/minecraft/world/level/ChunkPos;DLnet/minecraft/client/renderer/chunk/RenderChunkRegion;Z)V"}, at={@At(value="RETURN")})
    private void setLevel(ChunkRenderDispatcher.RenderChunk this$1, ChunkPos pos, double p_194427_, RenderChunkRegion region, boolean p_194429_, CallbackInfo ci) {
        this.flywheel$level = ((RenderChunkExtension)this$1).flywheel$getLevel();
    }

    @Redirect(method={"doTask"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z"))
    private <E extends BlockEntity> boolean addAndFilterBEs(List<BlockEntity> self, Collection<? extends E> es) {
        if (!Backend.canUseInstancing(this.flywheel$level)) {
            return self.addAll(es);
        }
        boolean added = false;
        ArrayList<BlockEntity> instanced = new ArrayList<BlockEntity>();
        for (BlockEntity be : es) {
            if (InstancedRenderRegistry.canInstance(be.m_58903_())) {
                instanced.add(be);
            }
            if (InstancedRenderRegistry.shouldSkipRender(be)) continue;
            self.add(be);
            added = true;
        }
        InstancedRenderDispatcher.getBlockEntities((LevelAccessor)this.flywheel$level).queueAddAll(instanced);
        return added;
    }

    @Redirect(method={"doTask"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk;updateGlobalBlockEntities(Ljava/util/Collection;)V"))
    private void addAndFilterBEs(ChunkRenderDispatcher.RenderChunk self, Collection<BlockEntity> bes) {
        if (!Backend.canUseInstancing(this.flywheel$level)) {
            ((RenderChunkAccessor)self).flywheel$updateGlobalBlockEntities(bes);
            return;
        }
        ArrayList<BlockEntity> global = new ArrayList<BlockEntity>();
        ArrayList<BlockEntity> instanced = new ArrayList<BlockEntity>();
        for (BlockEntity be : bes) {
            if (InstancedRenderRegistry.canInstance(be.m_58903_())) {
                instanced.add(be);
            }
            if (InstancedRenderRegistry.shouldSkipRender(be)) continue;
            global.add(be);
        }
        InstancedRenderDispatcher.getBlockEntities((LevelAccessor)this.flywheel$level).queueAddAll(instanced);
        ((RenderChunkAccessor)self).flywheel$updateGlobalBlockEntities(global);
    }
}

