/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.compiler;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import top.leonx.irisflw.accessors.NewWorldRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramDirectivesAccessor;
import top.leonx.irisflw.compiler.IrisProgramCompilerBase;
import top.leonx.irisflw.transformer.ShaderPatcherBase;

public abstract class NewProgramCompiler<P extends WorldProgram>
extends IrisProgramCompilerBase<P> {
    private final Map<ProgramSet, ProgramFallbackResolver> resolvers = new HashMap<ProgramSet, ProgramFallbackResolver>();
    private final Iterable<StringPair> environmentDefines = StandardMacros.createStandardEnvironmentDefines();

    public abstract ShaderPatcherBase getShaderPatcher();

    public NewProgramCompiler(GlProgram.Factory<P> factory, Template<? extends VertexData> template, FileResolution header) {
        super(factory, template, header);
    }

    @Override
    P createIrisShaderProgram(ProgramContext ctx, boolean isShadow) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof NewWorldRenderingPipeline) {
            NewWorldRenderingPipeline newPipeline = (NewWorldRenderingPipeline)pipeline;
            ProgramSet programSet = ((NewWorldRenderingPipelineAccessor)newPipeline).getProgramSet();
            Optional<ProgramSource> sourceReferenceOpt = this.getProgramSourceReference(programSet, isShadow);
            if (sourceReferenceOpt.isEmpty()) {
                return null;
            }
            ProgramSource sourceRef = sourceReferenceOpt.get();
            if (sourceRef.getVertexSource().isEmpty()) {
                return null;
            }
            ShaderPatcherBase patcher = this.getShaderPatcher();
            String vertexSource = (String)sourceRef.getVertexSource().get();
            String newVertexSource = patcher.patch(vertexSource, new ShaderPatcherBase.Context(ctx.spec.getVertexFile(), ctx.ctx, ctx.vertexType));
            newVertexSource = JcppProcessor.glslPreprocessSource((String)newVertexSource, this.environmentDefines);
            ProgramSource newProgramSource = this.programSourceOverrideVertexSource(ctx, programSet, sourceRef, newVertexSource);
            ((ProgramDirectivesAccessor)newProgramSource.getDirectives()).setFlwAlphaTestOverride(new AlphaTest(AlphaTestFunction.GREATER, ctx.alphaDiscard));
            return this.createWorldProgramBySource(ctx, isShadow, (NewWorldRenderingPipelineAccessor)newPipeline, newProgramSource);
        }
        return null;
    }

    protected Optional<ProgramSource> getProgramSourceReference(ProgramSet programSet, boolean isShadow) {
        ProgramFallbackResolver resolver = this.resolvers.computeIfAbsent(programSet, ProgramFallbackResolver::new);
        if (isShadow) {
            return resolver.resolve(ProgramId.Shadow);
        }
        return resolver.resolve(ProgramId.Block);
    }

    @Override
    public void clear() {
        super.clear();
        this.resolvers.clear();
    }
}

