/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.network.SegmentedPaintingMessage;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ImageResponse
extends SegmentedPaintingMessage {
    private static final long serialVersionUID = -2404615222596628414L;
    private final String identifier;
    private final Painting.Type type;

    public ImageResponse(ResourceLocation identifier, Painting.Type type, byte[] data, int segment, int totalSegments) {
        super(data, segment, totalSegments);
        this.identifier = identifier.toString();
        this.type = type;
    }

    @Override
    protected String getIdentifier(Player e) {
        return this.identifier + this.type.name();
    }

    @Override
    protected void process(Player e, ByteImage image) {
        Painting painting = ClientPaintingManager.getPaintings().get(new ResourceLocation(this.identifier));
        Painting.Texture texture = painting.getTexture(this.type);
        texture.image = image;
        ClientPaintingManager.registerImage(texture);
        Cache.set(texture);
    }
}

