/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GantryCarriageBlock
extends DirectionalAxisKineticBlock
implements ITE<GantryCarriageTileEntity> {
    public GantryCarriageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState shaft = world.m_8055_(pos.m_121945_(direction.m_122424_()));
        return AllBlocks.GANTRY_SHAFT.has(shaft) && ((Direction)shaft.m_61143_((Property)GantryShaftBlock.FACING)).m_122434_() != direction.m_122434_();
    }

    @Override
    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        super.m_7742_(stateIn, worldIn, pos, flags, count);
        this.withTileEntityDo((BlockGetter)worldIn, pos, GantryCarriageTileEntity::checkValidGantryShaft);
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    @Override
    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        return context.m_43719_();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_36326_() || player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(handIn).m_41619_()) {
            this.withTileEntityDo((BlockGetter)worldIn, pos, te -> te.checkValidGantryShaft());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        Direction opposite = ((Direction)stateForPlacement.m_61143_((Property)FACING)).m_122424_();
        return this.cycleAxisIfNecessary(stateForPlacement, opposite, context.m_43725_().m_8055_(context.m_8083_().m_121945_(opposite)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos updatePos, boolean p_220069_6_) {
        if (updatePos.equals((Object)pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())) && !this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        if (state.m_61143_((Property)FACING) != direction.m_122424_()) {
            return state;
        }
        return this.cycleAxisIfNecessary(state, direction, otherState);
    }

    protected BlockState cycleAxisIfNecessary(BlockState state, Direction direction, BlockState otherState) {
        if (!AllBlocks.GANTRY_SHAFT.has(otherState)) {
            return state;
        }
        if (((Direction)otherState.m_61143_((Property)GantryShaftBlock.FACING)).m_122434_() == direction.m_122434_()) {
            return state;
        }
        if (GantryCarriageBlock.isValidGantryShaftAxis(state, otherState)) {
            return state;
        }
        return (BlockState)state.m_61122_((Property)AXIS_ALONG_FIRST_COORDINATE);
    }

    public static boolean isValidGantryShaftAxis(BlockState pinionState, BlockState gantryState) {
        return GantryCarriageBlock.getValidGantryShaftAxis(pinionState) == ((Direction)gantryState.m_61143_((Property)GantryShaftBlock.FACING)).m_122434_();
    }

    public static Direction.Axis getValidGantryShaftAxis(BlockState state) {
        if (!(state.m_60734_() instanceof GantryCarriageBlock)) {
            return Direction.Axis.Y;
        }
        IRotate block = (IRotate)state.m_60734_();
        Direction.Axis rotationAxis = block.getRotationAxis(state);
        Direction.Axis facingAxis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facingAxis) continue;
            return axis;
        }
        return Direction.Axis.Y;
    }

    public static Direction.Axis getValidGantryPinionAxis(BlockState state, Direction.Axis shaftAxis) {
        Direction.Axis facingAxis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == shaftAxis || axis == facingAxis) continue;
            return axis;
        }
        return Direction.Axis.Y;
    }

    @Override
    public Class<GantryCarriageTileEntity> getTileEntityClass() {
        return GantryCarriageTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends GantryCarriageTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.GANTRY_PINION.get();
    }
}

