/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryShaftTileEntity
extends KineticTileEntity {
    public GantryShaftTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void checkAttachedCarriageBlocks() {
        if (!this.canAssembleOn()) {
            return;
        }
        for (Direction d : Iterate.directions) {
            BlockEntity tileEntity;
            BlockPos offset;
            BlockState pinionState;
            if (d.m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)GantryShaftBlock.FACING)).m_122434_() || !AllBlocks.GANTRY_CARRIAGE.has(pinionState = this.f_58857_.m_8055_(offset = this.f_58858_.m_121945_(d))) || pinionState.m_61143_((Property)GantryCarriageBlock.FACING) != d || !((tileEntity = this.f_58857_.m_7702_(offset)) instanceof GantryCarriageTileEntity)) continue;
            ((GantryCarriageTileEntity)tileEntity).queueAssembly();
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.checkAttachedCarriageBlocks();
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!((Boolean)stateFrom.m_61143_((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        if (!AllBlocks.GANTRY_CARRIAGE.has(stateTo)) {
            return defaultModifier;
        }
        Direction direction = Direction.m_122372_((float)diff.m_123341_(), (float)diff.m_123342_(), (float)diff.m_123343_());
        if (stateTo.m_61143_((Property)GantryCarriageBlock.FACING) != direction) {
            return defaultModifier;
        }
        return GantryCarriageTileEntity.getGantryPinionModifier((Direction)stateFrom.m_61143_((Property)GantryShaftBlock.FACING), (Direction)stateTo.m_61143_((Property)GantryCarriageBlock.FACING));
    }

    @Override
    public boolean isCustomConnection(KineticTileEntity other, BlockState state, BlockState otherState) {
        if (!AllBlocks.GANTRY_CARRIAGE.has(otherState)) {
            return false;
        }
        BlockPos diff = other.m_58899_().m_121996_((Vec3i)this.f_58858_);
        Direction direction = Direction.m_122372_((float)diff.m_123341_(), (float)diff.m_123342_(), (float)diff.m_123343_());
        return otherState.m_61143_((Property)GantryCarriageBlock.FACING) == direction;
    }

    public boolean canAssembleOn() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.GANTRY_SHAFT.has(blockState)) {
            return false;
        }
        if (((Boolean)blockState.m_61143_((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        float speed = this.getPinionMovementSpeed();
        switch ((GantryShaftBlock.Part)((Object)blockState.m_61143_(GantryShaftBlock.PART))) {
            case END: {
                return speed < 0.0f;
            }
            case MIDDLE: {
                return speed != 0.0f;
            }
            case START: {
                return speed > 0.0f;
            }
        }
        return false;
    }

    public float getPinionMovementSpeed() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.GANTRY_SHAFT.has(blockState)) {
            return 0.0f;
        }
        return Mth.m_14036_((float)GantryShaftTileEntity.convertToLinear(-this.getSpeed()), (float)-0.49f, (float)0.49f);
    }

    @Override
    protected boolean isNoisy() {
        return false;
    }
}

