/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChuteBlock
extends AbstractChuteBlock {
    public static final Property<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;

    public ChuteBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL))).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    @Override
    public boolean isOpen(BlockState state) {
        return state.m_61143_((Property)FACING) == Direction.DOWN || state.m_61143_(SHAPE) == Shape.INTERSECTION;
    }

    @Override
    public boolean isTransparent(BlockState state) {
        return state.m_61143_(SHAPE) == Shape.WINDOW;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        boolean down;
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        boolean bl = down = state.m_61143_((Property)FACING) == Direction.DOWN;
        if (!context.m_43725_().f_46443_ && down && shape != Shape.INTERSECTION) {
            context.m_43725_().m_46597_(context.m_8083_(), (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(shape == Shape.WINDOW ? Shape.NORMAL : Shape.WINDOW))));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        Direction face = ctx.m_43719_();
        if (face.m_122434_().m_122479_() && !ctx.m_7078_()) {
            Level world = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            return this.updateChuteState((BlockState)state.m_61124_((Property)FACING, (Comparable)face), world.m_8055_(pos.m_7494_()), (BlockGetter)world, pos);
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_.m_61104_(new Property[]{SHAPE, FACING}));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState above = world.m_8055_(pos.m_7494_());
        return !ChuteBlock.isChute(above) || ChuteBlock.getChuteFacing(above) == Direction.DOWN;
    }

    @Override
    public BlockState updateChuteState(BlockState state, BlockState above, BlockGetter world, BlockPos pos) {
        boolean noConnections;
        BlockState target;
        boolean vertical;
        if (!(state.m_60734_() instanceof ChuteBlock)) {
            return state;
        }
        HashMap<BlockState, Boolean> connections = new HashMap<BlockState, Boolean>();
        int amtConnections = 0;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean bl = vertical = facing == Direction.DOWN;
        if (!vertical && !ChuteBlock.isChute(target = world.m_8055_(pos.m_7495_().m_121945_(facing.m_122424_())))) {
            return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        for (BlockState direction : Iterate.horizontalDirections) {
            BlockState diagonalInputChute = world.m_8055_(pos.m_7494_().m_121945_((Direction)direction));
            boolean value = diagonalInputChute.m_60734_() instanceof ChuteBlock && diagonalInputChute.m_61143_((Property)FACING) == direction;
            connections.put(direction, value);
            if (!value) continue;
            ++amtConnections;
        }
        boolean bl2 = noConnections = amtConnections == 0;
        if (vertical) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(noConnections ? (state.m_61143_(SHAPE) == Shape.WINDOW ? Shape.WINDOW : Shape.NORMAL) : Shape.INTERSECTION)));
        }
        if (noConnections) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.NORTH)).booleanValue() && ((Boolean)connections.get(Direction.SOUTH)).booleanValue()) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.EAST)).booleanValue() && ((Boolean)connections.get(Direction.WEST)).booleanValue()) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (amtConnections == 1 && ((Boolean)connections.get(facing)).booleanValue() && ChuteBlock.getChuteFacing(above) != Direction.DOWN && (!(above.m_60734_() instanceof FunnelBlock) || FunnelBlock.getFunnelFacing(above) != Direction.DOWN)) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public BlockEntityType<? extends ChuteTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.CHUTE.get();
    }

    public static enum Shape implements StringRepresentable
    {
        INTERSECTION,
        WINDOW,
        NORMAL;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

