/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.api.MaterialManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.track.StandardBogeyTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.EnumSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StandardBogeyBlock
extends Block
implements IBogeyBlock,
ITE<StandardBogeyTileEntity>,
ProperWaterloggedBlock,
ISpecialBlockItemRequirement {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private final boolean large;
    static final EnumSet<Direction> STICKY_X = EnumSet.of(Direction.EAST, Direction.WEST);
    static final EnumSet<Direction> STICKY_Z = EnumSet.of(Direction.SOUTH, Direction.NORTH);

    public StandardBogeyBlock(BlockBehaviour.Properties p_i48440_1_, boolean large) {
        super(p_i48440_1_);
        this.large = large;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, WATERLOGGED});
        super.m_7926_(builder);
    }

    @Override
    public EnumSet<Direction> getStickySurfaces(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? STICKY_X : STICKY_Z;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    @Override
    public double getWheelPointSpacing() {
        return 2.0;
    }

    @Override
    public double getWheelRadius() {
        return (this.large ? 12.5 : 6.5) / 16.0;
    }

    @Override
    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, 0.21875, 1.0);
    }

    @Override
    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    @Override
    public BlockState getMatchingBogey(Direction upDirection, boolean axisAlongFirst) {
        if (upDirection != Direction.UP) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)(axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z));
    }

    @Override
    public boolean isTrackAxisAlongFirstCoordinate(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.X;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockState state, float wheelAngle, PoseStack ms, float partialTicks, MultiBufferSource buffers, int light, int overlay) {
        if (state != null) {
            ms.m_85837_(0.5, 0.5, 0.5);
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
        ms.m_85837_(0.0, -1.5078125, 0.0);
        VertexConsumer vb = buffers.m_6299_(RenderType.m_110457_());
        BlockState air = Blocks.f_50016_.m_49966_();
        for (int i : Iterate.zeroAndOne) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.block((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z)).translate(-0.5, 0.25, i * -1).centre()).rotateZ(wheelAngle)).unCentre()).light(light).renderInto(ms, vb);
        }
        if (this.large) {
            this.renderLargeBogey(wheelAngle, ms, light, vb, air);
        } else {
            this.renderBogey(wheelAngle, ms, light, vb, air);
        }
    }

    private void renderBogey(float wheelAngle, PoseStack ms, int light, VertexConsumer vb, BlockState air) {
        ((SuperByteBuffer)CachedBufferer.partial(AllBlockPartials.BOGEY_FRAME, air).scale(0.9980469f)).light(light).renderInto(ms, vb);
        for (int side : Iterate.positiveAndNegative) {
            ms.m_85836_();
            ((SuperByteBuffer)CachedBufferer.partial(AllBlockPartials.SMALL_BOGEY_WHEELS, air).translate(0.0, 0.75, side).rotateX(wheelAngle)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
    }

    private void renderLargeBogey(float wheelAngle, PoseStack ms, int light, VertexConsumer vb, BlockState air) {
        for (int i : Iterate.zeroAndOne) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.block((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.X)).translate(-0.5, 0.25, 0.5f + (float)(i * -2)).centre()).rotateX(wheelAngle)).unCentre()).light(light).renderInto(ms, vb);
        }
        ((SuperByteBuffer)CachedBufferer.partial(AllBlockPartials.BOGEY_DRIVE, air).scale(0.9980469f)).light(light).renderInto(ms, vb);
        CachedBufferer.partial(AllBlockPartials.BOGEY_PISTON, air).translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad(wheelAngle))).light(light).renderInto(ms, vb);
        ms.m_85836_();
        ((SuperByteBuffer)CachedBufferer.partial(AllBlockPartials.LARGE_BOGEY_WHEELS, air).translate(0.0, 1.0, 0.0).rotateX(wheelAngle)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial(AllBlockPartials.BOGEY_PIN, air).translate(0.0, 1.0, 0.0).rotateX(wheelAngle)).translate(0.0, 0.25, 0.0).rotateX(-wheelAngle)).light(light).renderInto(ms, vb);
        ms.m_85849_();
    }

    @Override
    public BogeyInstance createInstance(MaterialManager materialManager, CarriageBogey bogey) {
        if (this.large) {
            return new BogeyInstance.Drive(bogey, materialManager);
        }
        return new BogeyInstance.Frame(bogey, materialManager);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)pState.m_61122_(AXIS);
            default -> pState;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    @Override
    public Class<StandardBogeyTileEntity> getTileEntityClass() {
        return StandardBogeyTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends StandardBogeyTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.BOGEY.get();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.RAILWAY_CASING.asStack());
    }
}

