/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.tileentities;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.rabbitminers.extendedgears.basecog.ICustomCogWheel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedKineticTileRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CogWheelKineticTileRenderer
extends BracketedKineticTileRenderer {
    public CogWheelKineticTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        PartialModel model = ICustomCogWheel.getPartialModelType(te.m_58900_());
        if (model == null) {
            model = AllBlockPartials.SHAFTLESS_COGWHEEL;
        }
        Direction.Axis axis = CogWheelKineticTileRenderer.getRotationAxisOf((KineticTileEntity)te);
        BlockPos pos = te.m_58899_();
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        if (!AllBlocks.LARGE_COGWHEEL.has(te.m_58900_())) {
            CogWheelKineticTileRenderer.renderRotatingBuffer((KineticTileEntity)te, (SuperByteBuffer)CachedBufferer.partialFacingVertical((PartialModel)model, (BlockState)te.m_58900_(), (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
        } else {
            CogWheelKineticTileRenderer.renderRotatingBuffer((KineticTileEntity)te, (SuperByteBuffer)CachedBufferer.partialFacingVertical((PartialModel)model, (BlockState)te.m_58900_(), (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
        }
        float offset = CogWheelKineticTileRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer shaft = CachedBufferer.partialFacingVertical((PartialModel)AllBlockPartials.COGWHEEL_SHAFT, (BlockState)te.m_58900_(), (Direction)facing);
        CogWheelKineticTileRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticTileEntity)te, (Direction.Axis)axis, (float)angle, (int)light);
        shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

