/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.AABB;

public class AdvancedShadowCullingFrustum
extends Frustum {
    private static final int MAX_CLIPPING_PLANES = 30;
    private final Vector4f[] planes = new Vector4f[30];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final Vector3f shadowLightVectorFromOrigin;
    private final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(Matrix4f playerView, Matrix4f playerProjection, Vector3f shadowLightVectorFromOrigin, BoxCuller boxCuller) {
        super(new Matrix4f(), new Matrix4f());
        this.shadowLightVectorFromOrigin = shadowLightVectorFromOrigin;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(playerView, playerProjection);
        boolean[] isBack = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, isBack);
        this.boxCuller = boxCuller;
    }

    private void addPlane(Vector4f plane) {
        this.planes[this.planeCount] = plane;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        boolean[] isBack = new boolean[planes.length];
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            Vector4f plane = planes[planeIndex];
            Vector3f planeNormal = this.truncate(plane);
            float dot = planeNormal.m_122276_(this.shadowLightVectorFromOrigin);
            boolean back = (double)dot > 0.0;
            boolean edge = (double)dot == 0.0;
            isBack[planeIndex] = back;
            if (!back && !edge) continue;
            this.addPlane(plane);
        }
        return isBack;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            if (!isBack[planeIndex]) continue;
            Vector4f plane = planes[planeIndex];
            NeighboringPlaneSet neighbors = NeighboringPlaneSet.forPlane(planeIndex);
            if (!isBack[neighbors.getPlane0()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane0()]);
            }
            if (!isBack[neighbors.getPlane1()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane1()]);
            }
            if (!isBack[neighbors.getPlane2()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane2()]);
            }
            if (isBack[neighbors.getPlane3()]) continue;
            this.addEdgePlane(plane, planes[neighbors.getPlane3()]);
        }
    }

    private Vector3f truncate(Vector4f base) {
        return new Vector3f(base.m_123601_(), base.m_123615_(), base.m_123616_());
    }

    private Vector4f extend(Vector3f base, float w) {
        return new Vector4f(base.m_122239_(), base.m_122260_(), base.m_122269_(), w);
    }

    private float lengthSquared(Vector3f v) {
        float x = v.m_122239_();
        float y = v.m_122260_();
        float z = v.m_122269_();
        return x * x + y * y + z * z;
    }

    private Vector3f cross(Vector3f first, Vector3f second) {
        Vector3f result = new Vector3f(first.m_122239_(), first.m_122260_(), first.m_122269_());
        result.m_122279_(second);
        return result;
    }

    private void addEdgePlane(Vector4f backPlane4, Vector4f frontPlane4) {
        Vector3f backPlaneNormal = this.truncate(backPlane4);
        Vector3f frontPlaneNormal = this.truncate(frontPlane4);
        Vector3f intersection = this.cross(backPlaneNormal, frontPlaneNormal);
        Vector3f edgePlaneNormal = this.cross(intersection, this.shadowLightVectorFromOrigin);
        Vector3f ixb = this.cross(intersection, backPlaneNormal);
        Vector3f fxi = this.cross(frontPlaneNormal, intersection);
        ixb.m_122261_(-frontPlane4.m_123617_());
        fxi.m_122261_(-backPlane4.m_123617_());
        ixb.m_122253_(fxi);
        Vector3f point = ixb;
        point.m_122261_(1.0f / this.lengthSquared(intersection));
        float d = edgePlaneNormal.m_122276_(point);
        float w = -d;
        Vector4f plane = this.extend(edgePlaneNormal, w);
        this.addPlane(plane);
    }

    public void m_113002_(double cameraX, double cameraY, double cameraZ) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(cameraX, cameraY, cameraZ);
        }
        this.x = cameraX;
        this.y = cameraY;
        this.z = cameraZ;
    }

    public boolean m_113029_(AABB aabb) {
        if (this.boxCuller != null && this.boxCuller.isCulled(aabb)) {
            return false;
        }
        return this.isVisible(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_) != 0;
    }

    public int fastAabbTest(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.boxCuller != null && this.boxCuller.isCulled(minX, minY, minZ, maxX, maxY, maxZ)) {
            return 0;
        }
        return this.isVisible(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return false;
    }

    private int isVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float f = (float)(minX - this.x);
        float g = (float)(minY - this.y);
        float h = (float)(minZ - this.z);
        float i = (float)(maxX - this.x);
        float j = (float)(maxY - this.y);
        float k = (float)(maxZ - this.z);
        return this.checkCornerVisibility(f, g, h, i, j, k);
    }

    private int checkCornerVisibility(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        boolean inside = true;
        for (int i = 0; i < this.planeCount; ++i) {
            Vector4f plane = this.planes[i];
            float f = plane.m_123601_() * (plane.m_123601_() < 0.0f ? minX : maxX) + plane.m_123615_() * (plane.m_123615_() < 0.0f ? minY : maxY);
            float f2 = plane.m_123616_();
            float f3 = plane.m_123616_() < 0.0f ? minZ : maxZ;
            if (f + f2 * f3 >= -plane.m_123617_()) {
                inside &= plane.m_123601_() * (plane.m_123601_() < 0.0f ? maxX : minX) + plane.m_123615_() * (plane.m_123615_() < 0.0f ? maxY : minY) + plane.m_123616_() * (plane.m_123616_() < 0.0f ? maxZ : minZ) >= -plane.m_123617_();
                continue;
            }
            return 0;
        }
        return inside ? 1 : 2;
    }
}

