/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PreviewProviderRegistryImpl
implements PreviewProviderRegistry {
    private boolean locked = true;
    private final BiMap<ResourceLocation, PreviewProvider> providerIds = HashBiMap.create();
    private final Map<Item, PreviewProvider> providerItems = new HashMap<Item, PreviewProvider>();
    public static final PreviewProviderRegistryImpl INSTANCE = new PreviewProviderRegistryImpl();

    private PreviewProviderRegistryImpl() {
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void register(ResourceLocation id, PreviewProvider provider, Iterable<Item> items) {
        if (this.locked) {
            throw new IllegalStateException("attempted to register PreviewProvider outside ShulkerBoxTooltipApi.registerProviders");
        }
        if (this.providerIds.containsValue((Object)provider)) {
            throw new IllegalStateException("attempted to register PreviewProvider twice");
        }
        if (this.providerIds.containsKey((Object)id)) {
            ShulkerBoxTooltip.LOGGER.warn("registering PreviewProvider with an existing id: " + id);
        }
        int priority = provider.getPriority();
        this.providerIds.put((Object)id, (Object)provider);
        for (Item item : items) {
            PreviewProvider previousProvider = this.providerItems.get(item);
            if (previousProvider == null) {
                this.providerItems.put(item, provider);
                continue;
            }
            ResourceLocation previousId = this.getId(previousProvider);
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)item);
            if (priority > previousProvider.getPriority()) {
                ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + previousId + " with " + id + " for item " + itemId);
                this.providerItems.put(item, provider);
                continue;
            }
            ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + id + " with " + previousId + " for item " + itemId);
        }
    }

    @Override
    public void register(ResourceLocation id, PreviewProvider provider, Item ... items) {
        this.register(id, provider, Arrays.asList(items));
    }

    @Override
    public PreviewProvider get(ResourceLocation id) {
        return (PreviewProvider)this.providerIds.get((Object)id);
    }

    @Override
    public PreviewProvider get(ItemStack stack) {
        return this.providerItems.get(stack.m_41720_());
    }

    @Override
    public PreviewProvider get(Item item) {
        return this.providerItems.get(item);
    }

    @Override
    public ResourceLocation getId(PreviewProvider provider) {
        return (ResourceLocation)this.providerIds.inverse().get((Object)provider);
    }

    @Override
    public Set<Item> getItems(PreviewProvider provider) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<Item, PreviewProvider> entry : this.providerItems.entrySet()) {
            if (entry.getValue() != provider) continue;
            builder.add((Object)entry.getKey());
        }
        return builder.build();
    }

    @Override
    public Set<PreviewProvider> getProviders() {
        return this.providerIds.values();
    }

    @Override
    public Set<ResourceLocation> getIds() {
        return this.providerIds.keySet();
    }
}

