/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.impl.renderer.BasePreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VanillaPreviewRenderer
extends BasePreviewRenderer {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("textures/gui/container/bundle.png");
    public static final VanillaPreviewRenderer INSTANCE = new VanillaPreviewRenderer();

    VanillaPreviewRenderer() {
        super(18, 20, 2, 2);
    }

    @Override
    public int getWidth() {
        return this.getMaxRowSize() * 18 + 2;
    }

    @Override
    public int getHeight() {
        return this.getRowCount() * 20 + 3;
    }

    private int getColumnCount() {
        return Math.min(this.getMaxRowSize(), this.getInvSize());
    }

    private int getRowCount() {
        return (int)Math.ceil((double)this.getInvSize() / (double)this.getMaxRowSize());
    }

    @Override
    public void draw(int x, int y, int z, PoseStack matrices, Font textRenderer, ItemRenderer itemRenderer, TextureManager textureManager) {
        this.setTexture();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        this.drawBackground(x, ++y, z, this.getColumnCount(), this.getRowCount(), matrices);
        this.drawItems(x, y, z, textRenderer, itemRenderer);
    }

    private void drawBackground(int x, int y, int z, int columns, int rows, PoseStack matrices) {
        int row;
        for (row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.drawSprite(matrices, 1 + x + 18 * col, 1 + y + 20 * row, z, ClientBundleTooltip.Texture.SLOT);
            }
        }
        this.drawSprite(matrices, x, y, z, ClientBundleTooltip.Texture.BORDER_CORNER_TOP);
        this.drawSprite(matrices, x + columns * 18 + 1, y, z, ClientBundleTooltip.Texture.BORDER_CORNER_TOP);
        for (int col = 0; col < columns; ++col) {
            this.drawSprite(matrices, x + 1 + col * 18, y, z, ClientBundleTooltip.Texture.BORDER_HORIZONTAL_TOP);
            this.drawSprite(matrices, x + 1 + col * 18, y + rows * 20, z, ClientBundleTooltip.Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (row = 0; row < rows; ++row) {
            this.drawSprite(matrices, x, y + row * 20 + 1, z, ClientBundleTooltip.Texture.BORDER_VERTICAL);
            this.drawSprite(matrices, x + columns * 18 + 1, y + row * 20 + 1, z, ClientBundleTooltip.Texture.BORDER_VERTICAL);
        }
        this.drawSprite(matrices, x, y + rows * 20, z, ClientBundleTooltip.Texture.BORDER_CORNER_BOTTOM);
        this.drawSprite(matrices, x + columns * 18 + 1, y + rows * 20, z, ClientBundleTooltip.Texture.BORDER_CORNER_BOTTOM);
    }

    private void setTexture() {
        if (this.textureOverride == null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)DEFAULT_TEXTURE);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureOverride);
        }
    }

    private void drawSprite(PoseStack matrices, int x, int y, int z, ClientBundleTooltip.Texture sprite) {
        GuiComponent.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)z, (float)sprite.f_169919_, (float)sprite.f_169920_, (int)sprite.f_169921_, (int)sprite.f_169922_, (int)128, (int)128);
    }
}

