/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkSlabBlock;
import vazkii.quark.base.block.QuarkStairsBlock;
import vazkii.quark.base.block.QuarkWallBlock;
import vazkii.quark.base.handler.RenderLayerHandler;

public class VariantHandler {
    public static final List<QuarkSlabBlock> SLABS = new LinkedList<QuarkSlabBlock>();
    public static final List<QuarkStairsBlock> STAIRS = new LinkedList<QuarkStairsBlock>();
    public static final List<QuarkWallBlock> WALLS = new LinkedList<QuarkWallBlock>();

    public static Block addSlabStairsWall(IQuarkBlock block) {
        VariantHandler.addSlabAndStairs(block);
        VariantHandler.addWall(block);
        return block.getBlock();
    }

    public static IQuarkBlock addSlabAndStairs(IQuarkBlock block) {
        VariantHandler.addSlab(block);
        VariantHandler.addStairs(block);
        return block;
    }

    public static IQuarkBlock addSlab(IQuarkBlock block) {
        SLABS.add(new QuarkSlabBlock(block));
        return block;
    }

    public static IQuarkBlock addStairs(IQuarkBlock block) {
        STAIRS.add(new QuarkStairsBlock(block));
        return block;
    }

    public static IQuarkBlock addWall(IQuarkBlock block) {
        WALLS.add(new QuarkWallBlock(block));
        return block;
    }

    public static FlowerPotBlock addFlowerPot(Block block, String name, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> propertiesFunc) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.0f);
        props = propertiesFunc.apply(props);
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> block, props);
        RenderLayerHandler.setRenderType((Block)potted, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        ResourceLocation resLoc = RegistryHelper.getRegistryName((Object)block, (Registry)Registry.f_122824_);
        if (resLoc == null) {
            resLoc = new ResourceLocation("missingno");
        }
        RegistryHelper.registerBlock((Block)potted, (String)("potted_" + name), (boolean)false);
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(resLoc, () -> potted);
        return potted;
    }

    public static BlockBehaviour.Properties realStateCopy(IQuarkBlock parent) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent.getBlock());
        if (parent instanceof IVariantsShouldBeEmissive) {
            props = props.m_60991_((s, r, p) -> true);
        }
        return props;
    }

    public static interface IVariantsShouldBeEmissive {
    }
}

