/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.hint;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.module.hint.HintManager;

public class HintObject {
    private final ConfigFlagManager flagManager;
    private final QuarkModule module;
    private final String flag;
    private boolean negateFlag;
    private final Supplier<Optional<Object>> fieldGetter;
    private String key;

    public HintObject(ConfigFlagManager flagManager, QuarkModule module, Hint hint, Supplier<Optional<Object>> fieldGetter) {
        this.flagManager = flagManager;
        this.module = module;
        this.flag = hint.value();
        this.negateFlag = hint.negate();
        this.fieldGetter = fieldGetter;
        this.key = hint.key();
    }

    public boolean isEnabled() {
        return this.module.enabled && (this.flag.isEmpty() || this.flagManager.getFlag(this.flag) != this.negateFlag);
    }

    public void apply(BiConsumer<Item, Component> consumer) {
        Optional<Object> optional = this.fieldGetter.get();
        if (optional.isPresent()) {
            Object obj = optional.get();
            if (obj instanceof Iterable) {
                Iterable iterable = (Iterable)obj;
                this.applyIterable(consumer, iterable);
            } else if (obj instanceof TagKey) {
                TagKey tagKey = (TagKey)obj;
                this.applyTag(consumer, tagKey);
            } else {
                this.applyObject(consumer, obj);
            }
        }
    }

    private void applyTag(BiConsumer<Item, Component> consumer, TagKey<?> tagKey) {
        if (this.key.isEmpty()) {
            this.key = tagKey.f_203868_().m_135815_();
        }
        try {
            List<?> tagItems = MiscUtil.getTagValues(BuiltinRegistries.f_206379_, tagKey);
            this.applyIterable(consumer, tagItems);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Tag " + this.key + " failed to load. (Module " + this.module.displayName + ")", e);
        }
    }

    private void applyIterable(BiConsumer<Item, Component> consumer, Iterable<?> iterable) {
        if (this.key.isEmpty()) {
            throw new RuntimeException("Multi-item Hints need a defined key (Module " + this.module.displayName + ")");
        }
        for (Object inObj : iterable) {
            this.applyObject(consumer, inObj);
        }
    }

    private void applyObject(BiConsumer<Item, Component> consumer, Object obj) {
        if (!(obj instanceof ItemLike)) {
            throw new RuntimeException("Invalid hint object on Module " + this.module.displayName + " - " + obj);
        }
        ItemLike itemLike = (ItemLike)obj;
        this.applyTo(consumer, itemLike);
    }

    private void applyTo(BiConsumer<Item, Component> consumer, ItemLike itemLike) {
        if (this.key.isEmpty()) {
            HintManager.hintItem(consumer, itemLike);
        } else {
            HintManager.hintItem(consumer, itemLike, this.key);
        }
    }
}

