/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IIndirectConnector;
import vazkii.quark.api.IPistonCallback;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.module.SturdyStoneModule;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class PistonsMoveTileEntitiesModule
extends QuarkModule {
    private static final WeakHashMap<Level, Map<BlockPos, CompoundTag>> movements = new WeakHashMap();
    private static final WeakHashMap<Level, List<Pair<BlockPos, CompoundTag>>> delayedUpdates = new WeakHashMap();
    @Config
    public static boolean enableChestsMovingTogether = true;
    public static boolean staticEnabled;
    @Config
    public static List<String> renderBlacklist;
    @Config
    public static List<String> movementBlacklist;
    @Config
    public static List<String> delayedUpdateList;

    @Override
    public void register() {
        IIndirectConnector.INDIRECT_STICKY_BLOCKS.add((Pair<Predicate<BlockState>, IIndirectConnector>)Pair.of(ChestConnection.PREDICATE, (Object)ChestConnection.INSTANCE));
    }

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!delayedUpdates.containsKey(event.level) || event.phase == TickEvent.Phase.START) {
            return;
        }
        List<Pair<BlockPos, CompoundTag>> delays = delayedUpdates.get(event.level);
        if (delays.isEmpty()) {
            return;
        }
        for (Pair<BlockPos, CompoundTag> delay : delays) {
            BlockPos pos = (BlockPos)delay.getLeft();
            BlockState state = event.level.m_8055_(pos);
            BlockEntity entity = PistonsMoveTileEntitiesModule.loadBlockEntitySafe(event.level, pos, (CompoundTag)delay.getRight());
            PistonsMoveTileEntitiesModule.callCallback(entity, (NonNullConsumer<? super IPistonCallback>)((NonNullConsumer)IPistonCallback::onPistonMovementFinished));
            event.level.m_46717_(pos, state.m_60734_());
        }
        delays.clear();
    }

    @Override
    public void addAdditionalHints(BiConsumer<Item, Component> consumer) {
        MutableComponent comp = Component.m_237115_((String)"quark.jei.hint.piston_te");
        if (ModuleLoader.INSTANCE.isModuleEnabled(SturdyStoneModule.class)) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.piston_sturdy"));
        }
        if (GeneralConfig.pistonPushLimit != 12) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"quark.jei.hint.piston_max_blocks", (Object[])new Object[]{GeneralConfig.pistonPushLimit}));
        }
        consumer.accept(Items.f_41869_, (Component)comp);
        consumer.accept(Items.f_41862_, (Component)comp);
    }

    public static boolean shouldMoveTE(boolean te, BlockState state) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return te;
        }
        return PistonsMoveTileEntitiesModule.shouldMoveTE(state);
    }

    public static boolean shouldMoveTE(BlockState state) {
        if (state.m_61148_().containsKey((Object)JukeboxBlock.f_54254_) && ((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50040_) {
            return true;
        }
        ResourceLocation res = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        return res == null || movementBlacklist.contains(res.toString()) || movementBlacklist.contains(res.m_135827_());
    }

    public static void detachTileEntities(Level world, PistonStructureResolver helper, Direction facing, boolean extending) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return;
        }
        if (!extending) {
            facing = facing.m_122424_();
        }
        List moveList = helper.m_60436_();
        for (BlockPos pos : moveList) {
            BlockEntity tile;
            BlockState state = world.m_8055_(pos);
            if (!(state.m_60734_() instanceof EntityBlock) || (tile = world.m_7702_(pos)) == null) continue;
            PistonsMoveTileEntitiesModule.callCallback(tile, (NonNullConsumer<? super IPistonCallback>)((NonNullConsumer)IPistonCallback::onPistonMovementStarted));
            CompoundTag tag = tile.m_187480_();
            PistonsMoveTileEntitiesModule.setMovingBlockEntityData(world, pos.m_121945_(facing), tag);
            world.m_46747_(pos);
        }
    }

    public static boolean setPistonBlock(Level world, BlockPos pos, BlockState state, int flags) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            world.m_7731_(pos, state, flags);
            return false;
        }
        if (!enableChestsMovingTogether && state.m_61148_().containsKey((Object)ChestBlock.f_51479_)) {
            state = (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE);
        }
        Block block = state.m_60734_();
        CompoundTag entityTag = PistonsMoveTileEntitiesModule.getAndClearMovement(world, pos);
        boolean destroyed = false;
        if (entityTag != null) {
            BlockState currState = world.m_8055_(pos);
            BlockEntity currEntity = world.m_7702_(pos);
            CompoundTag currTag = currEntity == null ? null : currEntity.m_187480_();
            world.m_7471_(pos, false);
            if (!block.m_7898_(state, (LevelReader)world, pos)) {
                world.m_7731_(pos, state, flags);
                BlockEntity entity = PistonsMoveTileEntitiesModule.loadBlockEntitySafe(world, pos, entityTag);
                PistonsMoveTileEntitiesModule.callCallback(entity, (NonNullConsumer<? super IPistonCallback>)((NonNullConsumer)IPistonCallback::onPistonMovementFinished));
                Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
                world.m_7471_(pos, false);
                destroyed = true;
            }
            if (!destroyed) {
                world.m_46597_(pos, currState);
                if (currTag != null) {
                    PistonsMoveTileEntitiesModule.loadBlockEntitySafe(world, pos, currTag);
                }
            }
        }
        if (!destroyed) {
            world.m_7731_(pos, state, flags);
            if (world.m_7702_(pos) != null) {
                world.m_7731_(pos, state, 0);
            }
            if (entityTag != null && !world.f_46443_) {
                if (delayedUpdateList.contains(Objects.toString(Registry.f_122824_.m_7981_((Object)block)))) {
                    PistonsMoveTileEntitiesModule.registerDelayedUpdate(world, pos, entityTag);
                } else {
                    BlockEntity entity = PistonsMoveTileEntitiesModule.loadBlockEntitySafe(world, pos, entityTag);
                    PistonsMoveTileEntitiesModule.callCallback(entity, (NonNullConsumer<? super IPistonCallback>)((NonNullConsumer)IPistonCallback::onPistonMovementFinished));
                }
            }
            world.m_46672_(pos, block);
        }
        return false;
    }

    public static void setMovingBlockEntityData(Level world, BlockPos pos, CompoundTag nbt) {
        movements.computeIfAbsent(world, l -> new HashMap()).put(pos, nbt);
    }

    @Deprecated(forRemoval=true)
    public static BlockEntity getMovement(Level world, BlockPos pos) {
        return null;
    }

    public static CompoundTag getMovingBlockEntityData(Level world, BlockPos pos) {
        return PistonsMoveTileEntitiesModule.getMovingBlockEntityData(world, pos, false);
    }

    private static CompoundTag getMovingBlockEntityData(Level world, BlockPos pos, boolean remove) {
        if (!movements.containsKey(world)) {
            return null;
        }
        Map<BlockPos, CompoundTag> worldMovements = movements.get(world);
        if (!worldMovements.containsKey(pos)) {
            return null;
        }
        CompoundTag ret = worldMovements.get(pos);
        if (remove) {
            worldMovements.remove(pos);
        }
        return ret;
    }

    private static CompoundTag getAndClearMovement(Level world, BlockPos pos) {
        return PistonsMoveTileEntitiesModule.getMovingBlockEntityData(world, pos, true);
    }

    private static void registerDelayedUpdate(Level world, BlockPos pos, CompoundTag tag) {
        if (!delayedUpdates.containsKey(world)) {
            delayedUpdates.put(world, new ArrayList());
        }
        delayedUpdates.get(world).add((Pair<BlockPos, CompoundTag>)Pair.of((Object)pos, (Object)tag));
    }

    private static void callCallback(@Nullable BlockEntity entity, NonNullConsumer<? super IPistonCallback> caller) {
        if (entity != null) {
            entity.getCapability(QuarkCapabilities.PISTON_CALLBACK).ifPresent(caller);
        }
    }

    @Nullable
    private static BlockEntity loadBlockEntitySafe(Level level, BlockPos pos, CompoundTag tag) {
        BlockEntity inWorldEntity = level.m_7702_(pos);
        String expectedTypeStr = tag.m_128461_("id");
        if (inWorldEntity == null) {
            Quark.LOG.warn("No block entity found at {} (expected {})", (Object)pos.m_123344_(), (Object)expectedTypeStr);
            return null;
        }
        if (inWorldEntity.m_58903_() != ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(new ResourceLocation(expectedTypeStr))) {
            Quark.LOG.warn("Wrong block entity found at {} (expected {}, got {})", (Object)pos.m_123344_(), (Object)expectedTypeStr, (Object)BlockEntityType.m_58954_((BlockEntityType)inWorldEntity.m_58903_()));
            return null;
        }
        inWorldEntity.m_142466_(tag);
        inWorldEntity.m_6596_();
        return inWorldEntity;
    }

    static {
        renderBlacklist = Lists.newArrayList((Object[])new String[]{"psi:programmer", "botania:starfield"});
        movementBlacklist = Lists.newArrayList((Object[])new String[]{"minecraft:spawner", "integrateddynamics:cable", "randomthings:blockbreaker", "minecraft:ender_chest", "minecraft:enchanting_table", "minecraft:trapped_chest", "quark:spruce_trapped_chest", "quark:birch_trapped_chest", "quark:jungle_trapped_chest", "quark:acacia_trapped_chest", "quark:dark_oak_trapped_chest", "endergetic:bolloom_bud"});
        delayedUpdateList = Lists.newArrayList((Object[])new String[]{"minecraft:dispenser", "minecraft:dropper"});
    }

    public static class ChestConnection
    implements IIndirectConnector {
        public static ChestConnection INSTANCE = new ChestConnection();
        public static Predicate<BlockState> PREDICATE = ChestConnection::isValidState;

        @Override
        public boolean isEnabled() {
            return enableChestsMovingTogether;
        }

        private static boolean isValidState(BlockState state) {
            if (!(state.m_60734_() instanceof ChestBlock)) {
                return false;
            }
            ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            return type != ChestType.SINGLE;
        }

        @Override
        public boolean canConnectIndirectly(Level world, BlockPos ourPos, BlockPos sourcePos, BlockState ourState, BlockState sourceState) {
            ChestType ourType = (ChestType)ourState.m_61143_((Property)ChestBlock.f_51479_);
            Direction baseDirection = (Direction)ourState.m_61143_((Property)ChestBlock.f_51478_);
            Direction targetDirection = ourType == ChestType.LEFT ? baseDirection.m_122427_() : baseDirection.m_122428_();
            BlockPos targetPos = ourPos.m_121945_(targetDirection);
            return targetPos.equals((Object)sourcePos);
        }
    }
}

