/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CapturedMobInstance<T extends Entity> {
    protected final T entity;
    protected final float containerWidth;
    protected final float containerHeight;

    protected CapturedMobInstance(T entity, float width, float height) {
        this.entity = entity;
        this.containerWidth = width;
        this.containerHeight = height;
    }

    @Nullable
    public T getEntityForRenderer() {
        return this.entity;
    }

    public void containerTick(Level world, BlockPos pos, float entityScale, CompoundTag entityData) {
    }

    public InteractionResult onPlayerInteract(Level world, BlockPos pos, Player player, InteractionHand hand, CompoundTag entityData) {
        return InteractionResult.PASS;
    }

    public void onContainerWaterlogged(boolean waterlogged) {
        if (this.entity instanceof WaterAnimal && this.entity.m_20069_() != waterlogged) {
            ((Entity)this.entity).f_19798_ = waterlogged;
            Pair<Float, Float> dim = MobContainer.calculateMobDimensionsForContainer(this.entity, this.containerWidth, this.containerHeight, waterlogged);
            double py = (double)((Float)dim.getRight()).floatValue() + 1.0E-4;
            this.entity.m_6034_(this.entity.m_20185_(), py, this.entity.m_20189_());
            ((Entity)this.entity).f_19791_ = py;
        }
    }

    public static class Default<T extends Entity>
    extends CapturedMobInstance<T> {
        public Default(T entity, float width, float height) {
            super(entity, width, height);
        }
    }
}

