/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;

public class BlackboardManager {
    private static final LoadingCache<Key, Blackboard> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        Blackboard value = (Blackboard)i.getValue();
        if (value != null) {
            RenderSystem.m_69879_(value::close);
        }
    }).build((CacheLoader)new CacheLoader<Key, Blackboard>(){

        public Blackboard load(Key key) {
            return null;
        }
    });

    public static Blackboard getInstance(Key key) {
        Blackboard textureInstance = (Blackboard)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new Blackboard(BlackboardBlockTile.unpackPixels(key.values), key.glow);
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public static class Blackboard
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final Map<Direction, List<BakedQuad>> quadsCache = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final byte[][] pixels;
        private final boolean glow;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;

        private Blackboard(byte[][] pixels, boolean glow) {
            this.pixels = pixels;
            this.glow = glow;
        }

        public byte[][] getPixels() {
            return this.pixels;
        }

        public boolean isGlow() {
            return this.glow;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            for (int y = 0; y < this.pixels.length && y < 16; ++y) {
                for (int x = 0; x < this.pixels[y].length && x < 16; ++x) {
                    this.texture.m_117991_().m_84988_(x, y, Blackboard.getColoredPixel(this.pixels[x][y], x, y));
                }
            }
            this.texture.m_117985_();
            this.textureLocation = Minecraft.m_91087_().m_91097_().m_118490_("blackboard/", this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        private static int getColoredPixel(byte i, int x, int y) {
            int offset = i > 0 ? 16 : 0;
            int tint = BlackboardBlock.colorFromByte(i);
            TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
            TextureAtlasSprite sprite = textureMap.m_118316_(ModTextures.BLACKBOARD_TEXTURE);
            return Blackboard.getTintedColor(sprite, x, y, offset, tint);
        }

        private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
            if (sprite == null || sprite.m_118415_() == 0) {
                return -1;
            }
            int tintR = tint >> 16 & 0xFF;
            int tintG = tint >> 8 & 0xFF;
            int tintB = tint & 0xFF;
            int pixel = ClientPlatformHelper.getPixelRGBA((TextureAtlasSprite)sprite, (int)0, (int)Math.min(sprite.m_118405_() - 1, x + offset), (int)Math.min(sprite.m_118408_() - 1, y));
            int totalB = pixel >> 16 & 0xFF;
            int totalG = pixel >> 8 & 0xFF;
            int totalR = pixel & 0xFF;
            return NativeImage.m_84992_((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
        }

        @Nonnull
        public List<BakedQuad> getOrCreateModel(Direction dir, BiFunction<Blackboard, Direction, List<BakedQuad>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (Direction)d));
        }

        @Nonnull
        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nonnull
        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                Minecraft.m_91087_().m_91097_().m_118513_(this.textureLocation);
            }
        }
    }

    public static class Key
    implements TooltipComponent {
        private final long[] values;
        private final boolean glow;

        Key(long[] packed, boolean glowing) {
            this.values = packed;
            this.glow = glowing;
        }

        public static Key of(long[] packPixels, boolean glowing) {
            return new Key(packPixels, glowing);
        }

        public static Key of(long[] packPixels) {
            return new Key(packPixels, false);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            Key key = (Key)another;
            return Arrays.equals(this.values, key.values) && this.glow == key.glow;
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

