/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FeatherBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.IFrameBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrameBlockTile
extends MimicBlockTile {
    public FrameBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TIMBER_FRAME_TILE.get(), pos, state);
    }

    public boolean setHeldBlock(BlockState state) {
        this.mimic = state;
        if (this.f_58857_ instanceof ServerLevel) {
            this.m_6596_();
            int newLight = SuppPlatformStuff.getLightEmission(this.getHeldBlock(), this.f_58857_, this.f_58858_);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_((Property)FrameBlock.HAS_BLOCK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        return true;
    }

    public BlockState acceptBlock(BlockState state) {
        Block b = state.m_60734_();
        if (b == ModRegistry.DAUB.get() && CommonConfigs.Building.REPLACE_DAUB.get().booleanValue()) {
            IFrameBlock fb;
            Block s;
            Block block;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof IFrameBlock && (s = (fb = (IFrameBlock)block).getFilledBlock(state.m_60734_())) != null) {
                state = s.m_152465_(this.m_58900_());
                this.f_58857_.m_7731_(this.f_58858_, state, 3);
            }
        } else {
            this.setHeldBlock(state);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.requestModelReload();
            }
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult handleInteraction(Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace, boolean canStrip) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!player.m_150110_().f_35938_) return InteractionResult.FAIL;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (this.getHeldBlock().m_60795_()) {
                BlockState toPlace = blockItem.m_40614_().m_5573_(new BlockPlaceContext(player, hand, stack, trace));
                if (!FrameBlockTile.isValidBlock(toPlace, pos, level)) return InteractionResult.FAIL;
                BlockState newState = this.acceptBlock(toPlace);
                SoundType s = newState.m_60827_();
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                level.m_5594_(player, pos, s.m_56777_(), SoundSource.BLOCKS, (s.m_56773_() + 1.0f) / 2.0f, s.m_56774_() * 0.8f);
                if (player.m_150110_().f_35937_ || level.m_5776_()) return InteractionResult.m_19078_((boolean)level.f_46443_);
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (!canStrip || !(item instanceof AxeItem) || this.getHeldBlock().m_60795_() || !CommonConfigs.Building.AXE_TIMBER_FRAME_STRIP.get().booleanValue()) return InteractionResult.FAIL;
        BlockState held = this.getHeldBlock();
        if (!level.f_46443_) {
            Block.m_152435_((Level)level, (BlockPos)pos, (Direction)trace.m_82434_(), (ItemStack)new ItemStack((ItemLike)this.m_58900_().m_60734_()));
        }
        level.m_5594_(player, pos, this.m_58900_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
        level.m_46597_(pos, held);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean isValidBlock(@Nullable BlockState state, BlockPos pos, Level world) {
        if (state == null) {
            return false;
        }
        Block b = state.m_60734_();
        if (b.m_204297_().m_203656_(ModTags.FRAME_BLOCK_BLACKLIST) || b instanceof EntityBlock) {
            return false;
        }
        if (b instanceof FeatherBlock || b instanceof SoulSandBlock) {
            return true;
        }
        return state.m_60804_((BlockGetter)world, pos) && Block.m_49916_((VoxelShape)state.m_60812_((BlockGetter)world, pos));
    }
}

