/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.items.SafeItem;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryTooltip;
import net.mehvahdjukaar.supplementaries.integration.forge.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.integration.forge.QuarkInventoryTooltipComponent;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import vazkii.quark.addons.oddities.client.render.be.TinyPotatoRenderer;
import vazkii.quark.api.event.UsageTickerEvent;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.management.module.ExpandedItemInteractionsModule;

public class QuarkClientCompatImpl {
    private static final Lazy<SafeBlockTile> DUMMY_SAFE_TILE = Lazy.of(() -> new SafeBlockTile(BlockPos.f_121853_, ModRegistry.SAFE.get().m_49966_()));

    public static void initClient() {
        ClientPlatformHelper.addBlockEntityRenderersRegistration(QuarkClientCompatImpl::registerEntityRenderers);
        MinecraftForge.EVENT_BUS.addListener(QuarkClientCompatImpl::onItemTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(QuarkClientCompatImpl::quiverUsageTicker);
    }

    private static void registerEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
        event.register(QuarkCompatImpl.TATER_IN_A_JAR_TILE.get(), TaterInAJarTileRenderer::new);
    }

    public static void setupClient() {
        ClientPlatformHelper.registerRenderType((Block)QuarkCompatImpl.TATER_IN_A_JAR.get(), (RenderType)RenderType.m_110463_());
    }

    public static boolean shouldHaveButtonOnRight() {
        return !GeneralConfig.qButtonOnRight || !GeneralConfig.enableQButton;
    }

    public static boolean canRenderBlackboardTooltip() {
        return QuarkClientCompatImpl.canRenderQuarkTooltip();
    }

    public static boolean canRenderQuarkTooltip() {
        return ModuleLoader.INSTANCE.isModuleEnabled(ExpandedItemInteractionsModule.class) && (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.m_96638_());
    }

    public static void registerTooltipComponent(ClientPlatformHelper.TooltipComponentEvent event) {
        event.register(InventoryTooltip.class, QuarkInventoryTooltipComponent::new);
    }

    public static void onItemTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        Item item;
        ItemStack stack = event.getItemStack();
        if (QuarkClientCompatImpl.canRenderQuarkTooltip() && ((item = stack.m_41720_()) instanceof SafeItem || item instanceof SackItem)) {
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)false);
            if (cmp.m_128441_("LootTable")) {
                return;
            }
            if (item instanceof SafeItem) {
                ((SafeBlockTile)DUMMY_SAFE_TILE.get()).m_142466_(cmp);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && !((SafeBlockTile)DUMMY_SAFE_TILE.get()).canPlayerOpen((Player)Minecraft.m_91087_().f_91074_, false)) {
                    return;
                }
            }
            List tooltip = event.getTooltipElements();
            ArrayList tooltipCopy = new ArrayList(tooltip);
            for (int i = 1; i < tooltipCopy.size(); ++i) {
                String s;
                Either either = (Either)tooltipCopy.get(i);
                if (!either.left().isPresent() || (s = ((FormattedText)either.left().get()).getString()).startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                tooltip.remove(either);
            }
            if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.m_96638_()) {
                tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.shulker_box_shift")));
            }
        }
    }

    public static void quiverUsageTicker(UsageTickerEvent.GetCount event) {
        ItemStack selected;
        QuiverItem.Data data;
        IQuiverEntity qe;
        ItemStack q;
        Player player;
        if (event.currentRealStack.m_41720_() instanceof ProjectileWeaponItem && event.currentStack != event.currentRealStack && (player = event.player) instanceof IQuiverEntity && !(q = (qe = (IQuiverEntity)player).getQuiver()).m_41619_() && (data = QuiverItem.getQuiverData(q)) != null && event.currentStack.m_150930_((selected = data.getSelected()).m_41720_())) {
            int count = data.getSelectedArrowCount();
            Inventory inventory = event.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stackAt = inventory.m_8020_(i);
                if (!selected.m_150930_(stackAt.m_41720_())) continue;
                count += stackAt.m_41613_();
            }
            event.setResultCount(count);
        }
    }

    public static class TaterInAJarTileRenderer
    extends TinyPotatoRenderer {
        public TaterInAJarTileRenderer(BlockEntityRendererProvider.Context ctx) {
            super(ctx);
        }

        public void render(TinyPotatoBlockEntity potato, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
            ms.m_85836_();
            ms.m_85837_(0.0, 0.0625, 0.0);
            super.render(potato, partialTicks, ms, buffers, light, overlay);
            ms.m_85849_();
        }
    }
}

